/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.metrics.undertow;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.undertow.Undertow;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.session.SessionManagerStatistics;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.xnio.management.XnioWorkerMXBean;

public class UndertowMetrics
implements ApplicationListener<ApplicationStartedEvent> {
    public static final String UNDERTOW_METRIC_NAME_PREFIX = "undertow";
    private static final String METRIC_NAME_X_WORK_WORKER_POOL_CORE_SIZE = "undertow.xwork.worker.pool.core.size";
    private static final String METRIC_NAME_X_WORK_WORKER_POOL_MAX_SIZE = "undertow.xwork.worker.pool.max.size";
    private static final String METRIC_NAME_X_WORK_WORKER_POOL_SIZE = "undertow.xwork.worker.pool.size";
    private static final String METRIC_NAME_X_WORK_WORKER_THREAD_BUSY_COUNT = "undertow.xwork.worker.thread.busy.count";
    private static final String METRIC_NAME_X_WORK_IO_THREAD_COUNT = "undertow.xwork.io.thread.count";
    private static final String METRIC_NAME_X_WORK_WORKER_QUEUE_SIZE = "undertow.xwork.worker.queue.size";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_COUNT = "undertow.connectors.requests.count";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ERROR_COUNT = "undertow.connectors.requests.error.count";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE = "undertow.connectors.requests.active";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE_MAX = "undertow.connectors.requests.active.max";
    private static final String METRIC_NAME_CONNECTORS_BYTES_SENT = "undertow.connectors.bytes.sent";
    private static final String METRIC_NAME_CONNECTORS_BYTES_RECEIVED = "undertow.connectors.bytes.received";
    private static final String METRIC_NAME_CONNECTORS_PROCESSING_TIME = "undertow.connectors.processing.time";
    private static final String METRIC_NAME_CONNECTORS_PROCESSING_TIME_MAX = "undertow.connectors.processing.time.max";
    private static final String METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE = "undertow.connectors.connections.active";
    private static final String METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE_MAX = "undertow.connectors.connections.active.max";
    private static final String METRIC_NAME_SESSIONS_ACTIVE_MAX = "undertow.sessions.active.max";
    private static final String METRIC_NAME_SESSIONS_ACTIVE_CURRENT = "undertow.sessions.active.current";
    private static final String METRIC_NAME_SESSIONS_CREATED = "undertow.sessions.created";
    private static final String METRIC_NAME_SESSIONS_EXPIRED = "undertow.sessions.expired";
    private static final String METRIC_NAME_SESSIONS_REJECTED = "undertow.sessions.rejected";
    private static final String METRIC_NAME_SESSIONS_ALIVE_MAX = "undertow.sessions.alive.max";
    private static final Field UNDERTOW_FIELD = ReflectionUtils.findField(UndertowWebServer.class, (String)"undertow");
    private final Iterable<Tag> tags;

    public UndertowMetrics() {
        this.tags = Collections.emptyList();
    }

    public UndertowMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        UndertowWebServer undertowWebServer = UndertowMetrics.findUndertowWebServer(applicationContext);
        if (undertowWebServer == null) {
            return;
        }
        Undertow undertow = UndertowMetrics.getUndertow(undertowWebServer);
        XnioWorkerMXBean xWorker = undertow.getWorker().getMXBean();
        MeterRegistry registry = (MeterRegistry)applicationContext.getBean(MeterRegistry.class);
        this.registerXWorker(registry, xWorker);
        List listenerInfoList = undertow.getListenerInfo();
        listenerInfoList.forEach(listenerInfo -> this.registerConnectorStatistics(registry, (Undertow.ListenerInfo)listenerInfo));
        if (undertowWebServer instanceof UndertowServletWebServer) {
            SessionManagerStatistics statistics = ((UndertowServletWebServer)undertowWebServer).getDeploymentManager().getDeployment().getSessionManager().getStatistics();
            this.registerSessionStatistics(registry, statistics);
        }
    }

    private void registerXWorker(MeterRegistry registry, XnioWorkerMXBean workerMXBean) {
        Gauge.builder((String)METRIC_NAME_X_WORK_WORKER_POOL_CORE_SIZE, (Object)workerMXBean, XnioWorkerMXBean::getCoreWorkerPoolSize).description("XWork core worker pool size").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
        Gauge.builder((String)METRIC_NAME_X_WORK_WORKER_POOL_MAX_SIZE, (Object)workerMXBean, XnioWorkerMXBean::getMaxWorkerPoolSize).description("XWork max worker pool size").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
        Gauge.builder((String)METRIC_NAME_X_WORK_WORKER_POOL_SIZE, (Object)workerMXBean, XnioWorkerMXBean::getWorkerPoolSize).description("XWork worker pool size").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
        Gauge.builder((String)METRIC_NAME_X_WORK_WORKER_THREAD_BUSY_COUNT, (Object)workerMXBean, XnioWorkerMXBean::getBusyWorkerThreadCount).description("XWork busy worker thread count").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
        Gauge.builder((String)METRIC_NAME_X_WORK_IO_THREAD_COUNT, (Object)workerMXBean, XnioWorkerMXBean::getIoThreadCount).description("XWork io thread count").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
        Gauge.builder((String)METRIC_NAME_X_WORK_WORKER_QUEUE_SIZE, (Object)workerMXBean, XnioWorkerMXBean::getWorkerQueueSize).description("XWork worker queue size").tags(this.tags).tag("name", workerMXBean.getName()).register(registry);
    }

    private void registerConnectorStatistics(MeterRegistry registry, Undertow.ListenerInfo listenerInfo) {
        String protocol = listenerInfo.getProtcol();
        ConnectorStatistics statistics = listenerInfo.getConnectorStatistics();
        Gauge.builder((String)METRIC_NAME_CONNECTORS_REQUESTS_COUNT, (Object)statistics, ConnectorStatistics::getRequestCount).tags(this.tags).tag("protocol", protocol).register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_REQUESTS_ERROR_COUNT, (Object)statistics, ConnectorStatistics::getErrorCount).tags(this.tags).tag("protocol", protocol).register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE, (Object)statistics, ConnectorStatistics::getActiveRequests).tags(this.tags).tag("protocol", protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE_MAX, (Object)statistics, ConnectorStatistics::getMaxActiveRequests).tags(this.tags).tag("protocol", protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_BYTES_SENT, (Object)statistics, ConnectorStatistics::getBytesSent).tags(this.tags).tag("protocol", protocol).baseUnit("bytes").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_BYTES_RECEIVED, (Object)statistics, ConnectorStatistics::getBytesReceived).tags(this.tags).tag("protocol", protocol).baseUnit("bytes").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_PROCESSING_TIME, (Object)statistics, s -> TimeUnit.NANOSECONDS.toMillis(s.getProcessingTime())).tags(this.tags).tag("protocol", protocol).baseUnit("ms").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_PROCESSING_TIME_MAX, (Object)statistics, s -> TimeUnit.NANOSECONDS.toMillis(s.getMaxProcessingTime())).tags(this.tags).tag("protocol", protocol).baseUnit("ms").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE, (Object)statistics, ConnectorStatistics::getActiveConnections).tags(this.tags).tag("protocol", protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE_MAX, (Object)statistics, ConnectorStatistics::getMaxActiveConnections).tags(this.tags).tag("protocol", protocol).baseUnit("connections").register(registry);
    }

    private void registerSessionStatistics(MeterRegistry registry, SessionManagerStatistics statistics) {
        Gauge.builder((String)METRIC_NAME_SESSIONS_ACTIVE_MAX, (Object)statistics, SessionManagerStatistics::getMaxActiveSessions).tags(this.tags).baseUnit("sessions").register(registry);
        Gauge.builder((String)METRIC_NAME_SESSIONS_ACTIVE_CURRENT, (Object)statistics, SessionManagerStatistics::getActiveSessionCount).tags(this.tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)METRIC_NAME_SESSIONS_CREATED, (Object)statistics, SessionManagerStatistics::getCreatedSessionCount).tags(this.tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)METRIC_NAME_SESSIONS_EXPIRED, (Object)statistics, SessionManagerStatistics::getExpiredSessionCount).tags(this.tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)METRIC_NAME_SESSIONS_REJECTED, (Object)statistics, SessionManagerStatistics::getRejectedSessions).tags(this.tags).baseUnit("sessions").register(registry);
        TimeGauge.builder((String)METRIC_NAME_SESSIONS_ALIVE_MAX, (Object)statistics, (TimeUnit)TimeUnit.SECONDS, SessionManagerStatistics::getHighestSessionCount).tags(this.tags).register(registry);
    }

    private static Undertow getUndertow(UndertowWebServer undertowWebServer) {
        return (Undertow)ReflectionUtils.getField((Field)UNDERTOW_FIELD, (Object)undertowWebServer);
    }

    private static UndertowWebServer findUndertowWebServer(ConfigurableApplicationContext applicationContext) {
        WebServer webServer;
        if (applicationContext instanceof ReactiveWebServerApplicationContext) {
            webServer = ((ReactiveWebServerApplicationContext)applicationContext).getWebServer();
        } else if (applicationContext instanceof ServletWebServerApplicationContext) {
            webServer = ((ServletWebServerApplicationContext)applicationContext).getWebServer();
        } else {
            return null;
        }
        if (webServer instanceof UndertowWebServer) {
            return (UndertowWebServer)webServer;
        }
        return null;
    }

    static {
        Objects.requireNonNull(UNDERTOW_FIELD, "UndertowWebServer class field undertow not exist.");
        ReflectionUtils.makeAccessible((Field)UNDERTOW_FIELD);
    }
}

