/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.common;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.common.MessageQueueProperties;
import com.taotao.cloud.mq.common.MessageQueueProviderFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"taotao.cloud.mq.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MessageQueueProperties.class})
@Configuration(proxyBeanMethods=false)
public class MessageQueueAutoConfiguration {
    public static final String AUTOWIRED_MESSAGE_QUEUE_FACTORY = "Autowired MessageQueueProviderFactory";
    private final MessageQueueProperties messageQueueProperties;

    public MessageQueueAutoConfiguration(MessageQueueProperties messageQueueProperties) {
        this.messageQueueProperties = messageQueueProperties;
    }

    @Bean
    public MessageQueueProviderFactory messageQueueProviderFactory() {
        LogUtils.debug((String)AUTOWIRED_MESSAGE_QUEUE_FACTORY, (Object[])new Object[0]);
        return new MessageQueueProviderFactory(this.messageQueueProperties.getType());
    }
}

