/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.kafka.kafka.autoconfigure;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.core.configuration.AsyncAutoConfiguration;
import com.taotao.cloud.mq.common.MessageQueueAutoConfiguration;
import com.taotao.cloud.mq.common.MessageQueueConsumer;
import com.taotao.cloud.mq.common.MessageQueueProperties;
import com.taotao.cloud.mq.common.MessageQueueProvider;
import com.taotao.cloud.mq.common.MessageQueueProviderFactory;
import com.taotao.cloud.mq.kafka.kafka.core.KafkaConsumer;
import com.taotao.cloud.mq.kafka.kafka.core.KafkaProvider;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;

@AutoConfigureAfter(value={MessageQueueAutoConfiguration.class})
@ConditionalOnBean(value={KafkaProperties.class})
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnProperty(prefix="taotao.cloud.mq.kafka", name={"enabled"}, havingValue="true")
@Configuration(proxyBeanMethods=false)
public class KafkaMessageQueueAutoConfiguration {
    public static final String TYPE = "KAFKA";
    public static final String BEAN_CONSUMER = "kafkaConsumer";
    public static final String BEAN_PROVIDER = "kafkaProvider";
    public static final String AUTOWIRED_KAKFA_CONSUMER = "Autowired KafkaConsumer";
    public static final String AUTOWIRED_KAFKA_PROVIDER = "Autowired KafkaProvider";

    @Bean(value={"kafkaConsumer"})
    public KafkaConsumer kafkaConsumer(MessageQueueProperties messageQueueProperties, KafkaProperties kafkaProperties, ObjectProvider<List<MessageQueueConsumer>> messageListeners, ObjectProvider<ConsumerFactory<String, String>> consumerFactory, AsyncAutoConfiguration.AsyncThreadPoolTaskExecutor taskExecutor) {
        LogUtils.debug((String)AUTOWIRED_KAKFA_CONSUMER, (Object[])new Object[0]);
        return new KafkaConsumer(messageQueueProperties, kafkaProperties, (List)messageListeners.getIfAvailable(), (ConsumerFactory<String, String>)((ConsumerFactory)consumerFactory.getIfAvailable()), (TaskExecutor)taskExecutor);
    }

    @Bean(value={"kafkaProvider"})
    public MessageQueueProvider messageQueueProvider(KafkaTemplate<String, String> kafkaTemplate) {
        LogUtils.debug((String)AUTOWIRED_KAFKA_PROVIDER, (Object[])new Object[0]);
        MessageQueueProviderFactory.addBean((String)TYPE, (String)BEAN_PROVIDER);
        return new KafkaProvider(kafkaTemplate);
    }
}

