/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SizeUnit;

public class DemoPulsarClientInitUltimate {
    private static final DemoPulsarClientInitUltimate INSTANCE = new DemoPulsarClientInitUltimate();
    private volatile PulsarClient pulsarClient;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DefaultThreadFactory("pulsar-cli-init"));

    public static DemoPulsarClientInitUltimate getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(this::initWithRetry, 0L, 10L, TimeUnit.SECONDS);
    }

    private void initWithRetry() {
        try {
            this.pulsarClient = PulsarClient.builder().serviceUrl("http://127.0.0.1:8080").ioThreads(4).listenerThreads(10).memoryLimit(64L, SizeUnit.MEGA_BYTES).operationTimeout(5, TimeUnit.SECONDS).connectionTimeout(15, TimeUnit.SECONDS).build();
            LogUtils.info((String)"pulsar client init success", (Object[])new Object[0]);
            this.executorService.shutdown();
        }
        catch (Exception e) {
            LogUtils.error((String)"init pulsar error, exception is ", (Object[])new Object[]{e});
        }
    }

    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }
}

