/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.pulsar.model.DemoPulsarClientInit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Producer;

public class DemoPulsarStaticProducersInit {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("pulsar-producers-init").build();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, this.threadFactory);
    private final Map<String, Producer<byte[]>> producerMap = new ConcurrentHashMap<String, Producer<byte[]>>();
    private int initIndex = 0;
    private final List<String> topics;

    public DemoPulsarStaticProducersInit(List<String> topics) {
        this.topics = topics;
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(this::initWithRetry, 0L, 10L, TimeUnit.SECONDS);
    }

    private void initWithRetry() {
        if (this.initIndex == this.topics.size()) {
            this.executorService.shutdown();
            return;
        }
        while (this.initIndex < this.topics.size()) {
            try {
                DemoPulsarClientInit instance = DemoPulsarClientInit.getInstance();
                Producer producer = instance.getPulsarClient().newProducer().topic(this.topics.get(this.initIndex)).create();
                this.producerMap.put(this.topics.get(this.initIndex), (Producer<byte[]>)producer);
            }
            catch (Exception e) {
                LogUtils.error((String)"init pulsar producer error, exception is {}", (Object[])new Object[]{e});
                break;
            }
            ++this.initIndex;
        }
    }

    public Producer<byte[]> getProducers(String topic) {
        return this.producerMap.get(topic);
    }
}

