/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.pulsar.model.SendCallback;
import java.util.concurrent.Semaphore;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;

public class MessageListenerBlockListener<T>
implements MessageListener<T> {
    private final Semaphore semaphore = new Semaphore(500);

    public void received(Consumer<T> consumer, Message<T> msg) {
        try {
            this.semaphore.acquire();
            this.asyncPayload(msg.getData(), e -> {
                this.semaphore.release();
                if (e == null) {
                    consumer.acknowledgeAsync(msg);
                } else {
                    LogUtils.error((String)"exception is ", (Object[])new Object[]{e});
                    consumer.negativeAcknowledge(msg);
                }
            });
        }
        catch (Exception e2) {
            this.semaphore.release();
            consumer.negativeAcknowledge(msg);
        }
    }

    private void asyncPayload(byte[] msg, SendCallback sendCallback) {
        if (System.currentTimeMillis() % 2L == 0L) {
            sendCallback.callback(null);
        } else {
            sendCallback.callback(new Exception("exception"));
        }
    }
}

