/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;

public class MessageListenerSyncAtLeastOnce<T>
implements MessageListener<T> {
    public void received(Consumer<T> consumer, Message<T> msg) {
        try {
            boolean result = this.syncPayload(msg.getData());
            if (result) {
                consumer.acknowledgeAsync(msg);
            } else {
                consumer.negativeAcknowledge(msg);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"exception is ", (Object[])new Object[]{e});
            consumer.negativeAcknowledge(msg);
        }
    }

    private boolean syncPayload(byte[] msg) {
        return System.currentTimeMillis() % 2L == 0L;
    }
}

