/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;

public class MessageListenerSyncAtLeastOnceStrictlyOrdered<T>
implements MessageListener<T> {
    public void received(Consumer<T> consumer, Message<T> msg) {
        this.retryUntilSuccess(msg.getData());
        consumer.acknowledgeAsync(msg);
    }

    private void retryUntilSuccess(byte[] msg) {
        while (true) {
            try {
                boolean result;
                while (!(result = this.syncPayload(msg))) {
                }
            }
            catch (Exception e) {
                LogUtils.error((String)"exception is ", (Object[])new Object[]{e});
                continue;
            }
            break;
        }
    }

    private boolean syncPayload(byte[] msg) {
        return System.currentTimeMillis() % 2L == 0L;
    }
}

