/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.pulsar.model.DemoPulsarClientInit;
import com.taotao.cloud.mq.pulsar.model.DummyMessageListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;

public class PulsarConsumerInit {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("pulsar-consumer-init").build();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, this.threadFactory);
    private final String topic;
    private volatile Consumer<byte[]> consumer;

    public PulsarConsumerInit(String topic) {
        this.topic = topic;
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(this::initWithRetry, 0L, 10L, TimeUnit.SECONDS);
    }

    private void initWithRetry() {
        try {
            DemoPulsarClientInit instance = DemoPulsarClientInit.getInstance();
            this.consumer = instance.getPulsarClient().newConsumer().topic(new String[]{this.topic}).messageListener(new DummyMessageListener()).subscribe();
            this.executorService.shutdown();
        }
        catch (Exception e) {
            LogUtils.error((String)"init pulsar producer error, exception is ", (Object[])new Object[]{e});
        }
    }

    public Consumer<byte[]> getConsumer() {
        return this.consumer;
    }
}

