/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.pulsar.model;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.pulsar.model.DemoPulsarClientInit;
import com.taotao.cloud.mq.pulsar.model.DummyMessageListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;

public class PulsarConsumersInit {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("pulsar-consumers-init").build();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, this.threadFactory);
    private final Map<String, Consumer<byte[]>> consumerMap = new ConcurrentHashMap<String, Consumer<byte[]>>();
    private int initIndex = 0;
    private final List<String> topics;

    public PulsarConsumersInit(List<String> topics) {
        this.topics = topics;
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(this::initWithRetry, 0L, 10L, TimeUnit.SECONDS);
    }

    private void initWithRetry() {
        if (this.initIndex == this.topics.size()) {
            this.executorService.shutdown();
            return;
        }
        while (this.initIndex < this.topics.size()) {
            try {
                DemoPulsarClientInit instance = DemoPulsarClientInit.getInstance();
                Consumer consumer = instance.getPulsarClient().newConsumer().topic(new String[]{this.topics.get(this.initIndex)}).messageListener(new DummyMessageListener()).subscribe();
                this.consumerMap.put(this.topics.get(this.initIndex), (Consumer<byte[]>)consumer);
            }
            catch (Exception e) {
                LogUtils.error((String)"init pulsar producer error, exception is ", (Object[])new Object[]{e});
                break;
            }
            ++this.initIndex;
        }
    }

    public Consumer<byte[]> getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }
}

