/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rabbitmq.cache;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.rabbitmq.common.DetailResponse;
import com.taotao.cloud.mq.rabbitmq.producer.MessageSender;
import com.taotao.cloud.mq.rabbitmq.producer.MessageWithTime;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;

public class RetryCache {
    private MessageSender sender;
    private boolean stop = false;
    private final Map<Long, MessageWithTime> map = new ConcurrentSkipListMap<Long, MessageWithTime>();
    private final AtomicLong id = new AtomicLong();

    public void setSender(MessageSender sender) {
        this.sender = sender;
        this.startRetry();
    }

    public long generateId() {
        return this.id.incrementAndGet();
    }

    public void add(MessageWithTime messageWithTime) {
        this.map.putIfAbsent(messageWithTime.getId(), messageWithTime);
    }

    public void del(long id) {
        this.map.remove(id);
    }

    private void startRetry() {
        new Thread(() -> {
            while (!this.stop) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long now = System.currentTimeMillis();
                for (Map.Entry<Long, MessageWithTime> entry : this.map.entrySet()) {
                    DetailResponse res;
                    MessageWithTime messageWithTime = entry.getValue();
                    if (null == messageWithTime) continue;
                    if (messageWithTime.getTime() + 180000L < now) {
                        LogUtils.info((String)"send message {} failed after 3 min ", (Object[])new Object[]{messageWithTime});
                        this.del(entry.getKey());
                        continue;
                    }
                    if (messageWithTime.getTime() + 60000L >= now || (res = this.sender.send(messageWithTime)).isIfSuccess()) continue;
                    LogUtils.info((String)"retry send message failed {} errMsg {}", (Object[])new Object[]{messageWithTime, res.getErrMsg()});
                }
            }
        }).start();
    }
}

