/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rabbitmq.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.rabbitmq.producer.FastBuildRabbitMqProducer;
import com.taotao.cloud.mq.rabbitmq.properties.RabbitMQProperties;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={FastBuildRabbitMqProducer.class})
@EnableConfigurationProperties(value={RabbitMQProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.mq.rabbitmq", name={"enabled"}, havingValue="true")
public class RabbitMQAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RabbitMQAutoConfiguration.class, (String)"taotao-cloud-starter-mq-rabbitmq", (String[])new String[0]);
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        LogUtils.started(RabbitTemplate.class, (String)"taotao-cloud-starter-mq-rabbitmq", (String[])new String[0]);
        return new RabbitTemplate(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory connectionFactory(RabbitMQProperties rabbitMqProperties) {
        LogUtils.started(ConnectionFactory.class, (String)"taotao-cloud-starter-mq-rabbitmq", (String[])new String[0]);
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setAddresses(rabbitMqProperties.getAddresses());
        connectionFactory.setUsername(rabbitMqProperties.getUsername());
        connectionFactory.setPassword(rabbitMqProperties.getPassword());
        connectionFactory.setVirtualHost(rabbitMqProperties.getVirtualHost());
        connectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        return connectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public FastBuildRabbitMqProducer fastRabbitMqProducer(ConnectionFactory connectionFactory) {
        LogUtils.started(FastBuildRabbitMqProducer.class, (String)"taotao-cloud-starter-mq-rabbitmq", (String[])new String[0]);
        return new FastBuildRabbitMqProducer(connectionFactory);
    }
}

