/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.rabbitmq.cache.RetryCache;
import com.taotao.cloud.mq.rabbitmq.common.DetailResponse;
import com.taotao.cloud.mq.rabbitmq.producer.MessageSender;
import com.taotao.cloud.mq.rabbitmq.producer.MessageWithTime;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;

public class FastBuildRabbitMqProducer {
    private final ConnectionFactory connectionFactory;

    public FastBuildRabbitMqProducer(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public MessageSender buildDirectMessageSender(String exchange, String routingKey, String queue) throws IOException {
        return this.buildMessageSender(exchange, routingKey, queue, "direct");
    }

    public MessageSender buildTopicMessageSender(String exchange, String routingKey) throws IOException {
        return this.buildMessageSender(exchange, routingKey, null, "topic");
    }

    private MessageSender buildMessageSender(String exchange, String routingKey, String queue, String type) throws IOException {
        Connection connection = this.connectionFactory.createConnection();
        if (type.equals("direct")) {
            this.buildQueue(exchange, routingKey, queue, connection, "direct");
        } else if (type.equals("topic")) {
            this.buildTopic(exchange, connection);
        }
        final RabbitTemplate rabbitTemplate = new RabbitTemplate(this.connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setExchange(exchange);
        rabbitTemplate.setRoutingKey(routingKey);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        final RetryCache retryCache = new RetryCache();
        rabbitTemplate.setConfirmCallback((correlationData, ack, cause) -> {
            assert (correlationData != null);
            if (!ack) {
                LogUtils.info((String)("send message failed: " + cause + correlationData.toString()), (Object[])new Object[0]);
            } else {
                retryCache.del(Long.parseLong(Objects.requireNonNull(correlationData.getId())));
            }
        });
        rabbitTemplate.setReturnsCallback(message -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LogUtils.info((String)("send message failed: " + message.getReplyCode() + " " + message.getReplyText()), (Object[])new Object[0]);
            rabbitTemplate.send(message.getMessage());
        });
        return new MessageSender(){
            {
                retryCache.setSender(this);
            }

            @Override
            public DetailResponse send(Object message) {
                long id = retryCache.generateId();
                long time = System.currentTimeMillis();
                return this.send(new MessageWithTime(id, time, message));
            }

            @Override
            public DetailResponse send(MessageWithTime messageWithTime) {
                try {
                    retryCache.add(messageWithTime);
                    rabbitTemplate.correlationConvertAndSend(messageWithTime.getMessage(), new CorrelationData(String.valueOf(messageWithTime.getId())));
                }
                catch (Exception e) {
                    return new DetailResponse(false, "", "");
                }
                return new DetailResponse(true, "", "");
            }
        };
    }

    private void buildQueue(String exchange, String routingKey, String queue, Connection connection, String type) throws IOException {
        Channel channel = connection.createChannel(false);
        if ("direct".equals(type)) {
            channel.exchangeDeclare(exchange, "direct", true, false, null);
        } else if ("topic".equals(type)) {
            channel.exchangeDeclare(exchange, "topic", true, false, null);
        }
        channel.queueDeclare(queue, true, false, false, null);
        channel.queueBind(queue, exchange, routingKey);
        try {
            channel.close();
        }
        catch (TimeoutException e) {
            LogUtils.info((String)"close channel time out ", (Object[])new Object[]{e});
        }
    }

    private void buildTopic(String exchange, Connection connection) throws IOException {
        Channel channel = connection.createChannel(false);
        channel.exchangeDeclare(exchange, "topic", true, false, null);
    }
}

