/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.rabbitmq.common.DetailResponse;
import com.taotao.cloud.mq.rabbitmq.producer.MessageProducer;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMQBuildMessageProducer {
    @Autowired
    private ConnectionFactory connectionFactory;

    public MessageProducer buildMessageSender(String exchange, String routingKey, String queue) throws IOException {
        return this.buildMessageSender(exchange, routingKey, queue, "direct");
    }

    public MessageProducer buildTopicMessageSender(String exchange, String routingKey) throws IOException {
        return this.buildMessageSender(exchange, routingKey, null, "topic");
    }

    public MessageProducer buildMessageSender(String exchange, String routingKey, String queue, String type) throws IOException {
        Connection connection = this.connectionFactory.createConnection();
        if (type.equals("direct")) {
            this.buildQueue(exchange, routingKey, queue, connection, "direct");
        } else if (type.equals("topic")) {
            this.buildTopic(exchange, connection);
        }
        RabbitTemplate rabbitTemplate = new RabbitTemplate(this.connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setExchange(exchange);
        rabbitTemplate.setRoutingKey(routingKey);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        rabbitTemplate.setConfirmCallback((correlationData, ack, cause) -> {
            if (!ack) {
                LogUtils.info((String)("send message failed: " + cause + correlationData.toString()), (Object[])new Object[0]);
            }
        });
        rabbitTemplate.setReturnsCallback(callback -> {
            LogUtils.info((String)("send message failed: " + callback.getReplyCode() + " " + callback.getReplyText()), (Object[])new Object[0]);
            rabbitTemplate.send(callback.getMessage());
        });
        return new MessageProducer(){

            @Override
            public DetailResponse send(Object message) {
                return this.send(message);
            }
        };
    }

    private void buildQueue(String exchange, String routingKey, String queue, Connection connection, String type) throws IOException {
        Channel channel = connection.createChannel(false);
        if (type.equals("direct")) {
            channel.exchangeDeclare(exchange, "direct", true, false, null);
        } else if (type.equals("topic")) {
            channel.exchangeDeclare(exchange, "topic", true, false, null);
        }
        channel.queueDeclare(queue, true, false, false, null);
        channel.queueBind(queue, exchange, routingKey);
        try {
            channel.close();
        }
        catch (TimeoutException e) {
            LogUtils.info((String)"close channel time out ", (Object[])new Object[]{e});
        }
    }

    private void buildTopic(String exchange, Connection connection) throws IOException {
        Channel channel = connection.createChannel(false);
        channel.exchangeDeclare(exchange, "topic", true, false, null);
    }
}

