/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rocketmq.rocketmq.autoconfigure;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.common.MessageQueueAutoConfiguration;
import com.taotao.cloud.mq.common.MessageQueueConsumer;
import com.taotao.cloud.mq.common.MessageQueueProperties;
import com.taotao.cloud.mq.common.MessageQueueProvider;
import com.taotao.cloud.mq.common.MessageQueueProviderFactory;
import com.taotao.cloud.mq.rocketmq.rocketmq.core.RocketMQConsumer;
import com.taotao.cloud.mq.rocketmq.rocketmq.core.RocketMQProvider;
import com.taotao.cloud.mq.rocketmq.rocketmq.env.FixedRocketMQConsumerProperties;
import com.taotao.cloud.mq.rocketmq.rocketmq.env.FixedRocketMQProducerProperties;
import java.util.List;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureAfter(value={MessageQueueAutoConfiguration.class})
@ConditionalOnBean(value={RocketMQProperties.class})
@ConditionalOnClass(value={RocketMQTemplate.class})
@ConditionalOnProperty(prefix="taotao.cloud.mq.rocketmq", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={FixedRocketMQProducerProperties.class, FixedRocketMQConsumerProperties.class})
@Configuration(proxyBeanMethods=false)
public class RocketMQMessageQueueAutoConfiguration {
    public static final String ENABLED = "rocketmq.enabled";
    public static final String TYPE = "ROCKETMQ";
    public static final String BEAN_CONSUMER = "rocketMQConsumer";
    public static final String BEAN_PROVIDER = "rocketMQProvider";
    public static final String AUTOWIRED_ROCKET_MQ_CONSUMER = "Autowired RocketMQConsumer";
    public static final String AUTOWIRED_ROCKET_MQ_PROVIDER = "Autowired RocketMQProvider";

    @Bean(value={"rocketMQConsumer"})
    public RocketMQConsumer rocketMQConsumer(MessageQueueProperties messageQueueProperties, RocketMQProperties rocketMQProperties, FixedRocketMQConsumerProperties fixedRocketMQConsumerProperties, ObjectProvider<List<MessageQueueConsumer>> messageListeners) {
        LogUtils.debug((String)AUTOWIRED_ROCKET_MQ_CONSUMER, (Object[])new Object[0]);
        return new RocketMQConsumer(messageQueueProperties, rocketMQProperties, fixedRocketMQConsumerProperties, (List)messageListeners.getIfAvailable());
    }

    @Bean(value={"rocketMQProvider"})
    public MessageQueueProvider messageQueueProvider(RocketMQTemplate rocketMQTemplate, FixedRocketMQProducerProperties fixedRocketMQProducerProperties) {
        LogUtils.debug((String)AUTOWIRED_ROCKET_MQ_PROVIDER, (Object[])new Object[0]);
        MessageQueueProviderFactory.addBean((String)TYPE, (String)BEAN_PROVIDER);
        return new RocketMQProvider(rocketMQTemplate, fixedRocketMQProducerProperties);
    }
}

