/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.mq.rocketmq.rocketmq.core;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.mq.common.MessageQueueProvider;
import com.taotao.cloud.mq.common.producer.MessageQueueProducerException;
import com.taotao.cloud.mq.common.producer.MessageSendCallback;
import com.taotao.cloud.mq.common.producer.MessageSendResult;
import com.taotao.cloud.mq.rocketmq.rocketmq.env.FixedRocketMQProducerProperties;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.spring.core.RocketMQTemplate;

public class RocketMQProvider
implements MessageQueueProvider {
    private static final String ROCKETMQ_PROVIDER_SEND_INTERRUPTED = "RocketMQProvider send interrupted: {}";
    private static final String ROCKETMQ_PROVIDER_CONSUME_ERROR = "RocketMQProvider send error: {}";
    private final RocketMQTemplate rocketMQTemplate;
    private final FixedRocketMQProducerProperties fixedRocketMQProducerProperties;

    public RocketMQProvider(RocketMQTemplate rocketMQTemplate, FixedRocketMQProducerProperties fixedRocketMQProducerProperties) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.fixedRocketMQProducerProperties = fixedRocketMQProducerProperties;
    }

    public MessageSendResult syncSend(com.taotao.cloud.mq.common.Message message) throws MessageQueueProducerException {
        try {
            SendResult sendResult = this.rocketMQTemplate.getProducer().send(this.transfer(message));
            return this.transfer(sendResult);
        }
        catch (InterruptedException e) {
            LogUtils.error((String)ROCKETMQ_PROVIDER_SEND_INTERRUPTED, (Object[])new Object[]{e.getMessage(), e});
            Thread.currentThread().interrupt();
            throw new MessageQueueProducerException(e.getMessage());
        }
        catch (Exception e) {
            LogUtils.error((String)ROCKETMQ_PROVIDER_CONSUME_ERROR, (Object[])new Object[]{e.getMessage(), e});
            throw new MessageQueueProducerException(e.getMessage());
        }
    }

    public void asyncSend(com.taotao.cloud.mq.common.Message message, final MessageSendCallback messageCallback) throws MessageQueueProducerException {
        DefaultMQProducer producer = this.rocketMQTemplate.getProducer();
        if (StringUtils.isNotBlank((CharSequence)message.getNamespace())) {
            producer.setNamespace(message.getNamespace());
        } else if (StringUtils.isNotBlank((CharSequence)this.fixedRocketMQProducerProperties.getNamespace())) {
            producer.setNamespace(this.fixedRocketMQProducerProperties.getNamespace());
        }
        try {
            producer.send(this.transfer(message), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    messageCallback.onSuccess(RocketMQProvider.this.transfer(sendResult));
                }

                public void onException(Throwable e) {
                    messageCallback.onFailed(e);
                }
            });
        }
        catch (InterruptedException e) {
            LogUtils.error((String)ROCKETMQ_PROVIDER_SEND_INTERRUPTED, (Object[])new Object[]{e.getMessage(), e});
            Thread.currentThread().interrupt();
            throw new MessageQueueProducerException(e.getMessage());
        }
        catch (Exception e) {
            LogUtils.error((String)ROCKETMQ_PROVIDER_CONSUME_ERROR, (Object[])new Object[]{e.getMessage(), e});
            throw new MessageQueueProducerException(e.getMessage());
        }
    }

    private Message transfer(com.taotao.cloud.mq.common.Message message) {
        Message rocketMsg = new Message(message.getTopic(), message.getTags(), message.getKey(), message.getBody().getBytes(StandardCharsets.UTF_8));
        if (message.getDelayTimeLevel() > 0) {
            rocketMsg.setDelayTimeLevel(message.getDelayTimeLevel().intValue());
        }
        return rocketMsg;
    }

    private MessageSendResult transfer(SendResult sendResult) {
        MessageSendResult result = new MessageSendResult();
        result.setTopic(sendResult.getMessageQueue().getTopic());
        result.setPartition(Integer.valueOf(sendResult.getMessageQueue().getQueueId()));
        result.setOffset(Long.valueOf(sendResult.getQueueOffset()));
        result.setTransactionId(sendResult.getTransactionId());
        return result;
    }
}

