/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.office.convert.pdf2Img;

import com.google.common.collect.Lists;
import com.taotao.cloud.office.convert.util.MyFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class Pdf2PngUtil {
    private static final Integer DPI = 100;
    private static final String IMG_TYPE = "png";

    public List<byte[]> pdf2Png(byte[] pdfBytes) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (PDDocument document = PDDocument.load((byte[])pdfBytes);){
            PDFRenderer renderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(i, (float)DPI.intValue());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, IMG_TYPE, out);
                result.add(out.toByteArray());
            }
        }
        return result;
    }

    public List<File> pdf2Png(byte[] pdfBytes, String imgRootPath) throws IOException {
        List<byte[]> pngBytesList = this.pdf2Png(pdfBytes);
        ArrayList pngFileList = Lists.newArrayList();
        for (int i = 0; i < pngBytesList.size(); ++i) {
            String imgPath = imgRootPath + "/" + (i + 1) + ".png";
            File pngFile = MyFileUtil.writeFileContent(pngBytesList.get(i), imgPath);
            pngFileList.add(pngFile);
        }
        return pngFileList;
    }
}

