/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.office.utils.easyexcel.convert;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.taotao.cloud.office.utils.easyexcel.EasyExcelUtils;
import com.taotao.cloud.office.utils.easyexcel.annotation.ExcelDictFormat;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class ExcelDictConvert
implements Converter<Object> {
    public Class<Object> supportJavaTypeKey() {
        return Object.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public Object convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        ExcelDictFormat anno = this.getAnnotation(contentProperty.getField());
        String type = anno.dictType();
        String label = cellData.getStringValue();
        String value = StringUtils.isBlank((CharSequence)type) ? EasyExcelUtils.reverseByExp(label, anno.readConverterExp(), anno.separator()) : "";
        return Convert.convert(contentProperty.getField().getType(), (Object)value);
    }

    public WriteCellData<String> convertToExcelData(Object object, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (ObjectUtil.isNull((Object)object)) {
            return new WriteCellData("");
        }
        ExcelDictFormat anno = this.getAnnotation(contentProperty.getField());
        String type = anno.dictType();
        String value = Convert.toStr((Object)object);
        String label = StringUtils.isBlank((CharSequence)type) ? EasyExcelUtils.convertByExp(value, anno.readConverterExp(), anno.separator()) : "";
        return new WriteCellData(label);
    }

    private ExcelDictFormat getAnnotation(Field field) {
        return (ExcelDictFormat)AnnotationUtil.getAnnotation((AnnotatedElement)field, ExcelDictFormat.class);
    }
}

