/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.office.convert.html2img;

import com.aspose.words.Document;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.PageSet;
import com.aspose.words.SaveOptions;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Html2PngUtil {
    public static List<byte[]> htmlBytes2PngBytes(byte[] htmlBytes) throws Exception {
        Document doc = new Document((InputStream)new ByteArrayInputStream(htmlBytes));
        ImageSaveOptions iso = new ImageSaveOptions(101);
        iso.setResolution(128.0f);
        iso.setPrettyFormat(true);
        iso.setUseAntiAliasing(true);
        ArrayList pngList = Lists.newArrayList();
        for (int i = 0; i < doc.getPageCount(); ++i) {
            PageSet pageSet = new PageSet(i);
            iso.setPageSet(pageSet);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            doc.save((OutputStream)outputStream, (SaveOptions)iso);
            pngList.add(outputStream.toByteArray());
        }
        return pngList;
    }

    public static List<File> htmlBytes2PngFileList(byte[] htmlBytes, String imgRootPath) throws Exception {
        Document doc = new Document((InputStream)new ByteArrayInputStream(htmlBytes));
        ImageSaveOptions iso = new ImageSaveOptions(101);
        iso.setResolution(128.0f);
        iso.setPrettyFormat(true);
        iso.setUseAntiAliasing(true);
        ArrayList pngList = Lists.newArrayList();
        for (int i = 0; i < doc.getPageCount(); ++i) {
            String imgPath = imgRootPath + "/" + (i + 1) + ".png";
            PageSet pageSet = new PageSet(i);
            iso.setPageSet(pageSet);
            doc.save(imgPath, (SaveOptions)iso);
            pngList.add(new File(imgPath));
        }
        return pngList;
    }
}

