/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.office.utils.csv;

import cn.hutool.core.collection.ListUtil;
import com.taotao.cloud.office.util.constant.ImportConstant;
import com.taotao.cloud.office.util.refactor.ThrowingConsumer;
import com.taotao.cloud.office.util.valid.ImportValid;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.RetryableErrorHandler;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.RowListProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.util.List;

public class CsvImportUtil<T> {
    public static <T> void importCsvWithString(InputStream inputStream, List<String> errorList, Class rowDto, ThrowingConsumer<List<String[]>> rowAction) {
        RowListProcessor rowListProcessor = new RowListProcessor();
        CsvParserSettings setting = CsvImportUtil.getDefaultSetting(errorList);
        setting.setProcessor((Processor)rowListProcessor);
        CsvParser csvParser = new CsvParser(setting);
        csvParser.parse(inputStream);
        List rowDataList = rowListProcessor.getRows();
        CsvImportUtil.persistentStringDataToDb(rowDataList, rowAction);
    }

    private static <T> void persistentStringDataToDb(List<String[]> data, ThrowingConsumer<List<String[]>> persistentActionMethod) {
        List dataList = ListUtil.split(data, (int)ImportConstant.MAX_INSERT_COUNT);
        dataList.stream().forEach(persistentActionMethod);
    }

    public static <T> void importCsvWithBean(InputStream inputStream, List<String> errorList, Class rowDtoClass, ThrowingConsumer<List<T>> rowAction) {
        BeanListProcessor rowProcessor = new BeanListProcessor(rowDtoClass);
        CsvParserSettings setting = CsvImportUtil.getDefaultSetting(errorList);
        setting.setProcessor((Processor)rowProcessor);
        CsvParser csvParser = new CsvParser(setting);
        csvParser.parse(inputStream);
        List dataList = rowProcessor.getBeans();
        for (Object row : dataList) {
            ImportValid.validRequireField(row, errorList);
        }
        CsvImportUtil.persistentBeanDataToDb(dataList, rowAction);
    }

    private static <T> void persistentBeanDataToDb(List<T> data, ThrowingConsumer<List<T>> persistentActionMethod) {
        List dataList = ListUtil.split(data, (int)ImportConstant.MAX_INSERT_COUNT);
        dataList.stream().forEach(persistentActionMethod);
    }

    private static CsvParserSettings getDefaultSetting(final List<String> errorList) {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        settings.setLineSeparatorDetectionEnabled(Boolean.TRUE.booleanValue());
        settings.setHeaderExtractionEnabled(true);
        settings.setProcessorErrorHandler((ProcessorErrorHandler)new RetryableErrorHandler<ParsingContext>(){

            public void handleError(DataProcessingException error, Object[] inputRow, ParsingContext context) {
                String errorLog = "row error details: column '" + error.getColumnName() + "' (index " + error.getColumnIndex() + ") has value '" + inputRow[error.getColumnIndex()] + " transfer error";
                errorList.add(errorLog);
            }
        });
        return settings;
    }
}

