/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import jakarta.annotation.PreDestroy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class HttpClientAutoConfiguration
implements InitializingBean {
    private CloseableHttpClient httpClient5;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HttpClientAutoConfiguration.class, (String)"taotao-cloud-starter-openfeign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
    public HttpClientConnectionManager hc5ConnectionManager(FeignHttpClientProperties httpClientProperties) {
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(this.httpsSSLConnectionSocketFactory(httpClientProperties.isDisableSslValidation())).setMaxConnTotal(httpClientProperties.getMaxConnections()).setMaxConnPerRoute(httpClientProperties.getMaxConnectionsPerRoute()).setConnPoolPolicy(PoolReusePolicy.valueOf((String)httpClientProperties.getHc5().getPoolReusePolicy().name())).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.valueOf((String)httpClientProperties.getHc5().getPoolConcurrencyPolicy().name())).setConnectionTimeToLive(TimeValue.of((long)httpClientProperties.getTimeToLive(), (TimeUnit)httpClientProperties.getTimeToLiveUnit())).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of((long)httpClientProperties.getHc5().getSocketTimeout(), (TimeUnit)httpClientProperties.getHc5().getSocketTimeoutUnit())).build()).build();
    }

    @Bean
    public CloseableHttpClient httpClient5(HttpClientConnectionManager connectionManager, FeignHttpClientProperties httpClientProperties) {
        this.httpClient5 = HttpClients.custom().disableCookieManagement().useSystemProperties().setConnectionManager(connectionManager).evictExpiredConnections().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.of((long)httpClientProperties.getConnectionTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)).setRedirectsEnabled(httpClientProperties.isFollowRedirects()).build()).build();
        return this.httpClient5;
    }

    @PreDestroy
    public void destroy() {
        if (this.httpClient5 != null) {
            this.httpClient5.close(CloseMode.GRACEFUL);
        }
    }

    private LayeredConnectionSocketFactory httpsSSLConnectionSocketFactory(boolean isDisableSslValidation) {
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create().setTlsVersions(new TLS[]{TLS.V_1_3, TLS.V_1_2});
        if (isDisableSslValidation) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new DisabledValidationTrustManager()}, new SecureRandom());
                sslConnectionSocketFactoryBuilder.setSslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LogUtils.warn((String)"Error creating SSLContext", (Object[])new Object[]{e});
            }
        } else {
            sslConnectionSocketFactoryBuilder.setSslContext(SSLContexts.createSystemDefault());
        }
        return sslConnectionSocketFactoryBuilder.build();
    }

    static class DisabledValidationTrustManager
    implements X509TrustManager {
        DisabledValidationTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

