/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.openfeign.annotation.ConditionalOnFeignUseOkHttp;
import jakarta.annotation.PreDestroy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.loadbalancer.FeignLoadBalancerAutoConfiguration;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={FeignLoadBalancerAutoConfiguration.class})
@ConditionalOnFeignUseOkHttp
public class OkHttpAutoConfiguration
implements InitializingBean {
    private OkHttpClient okHttpClient;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(OkHttpAutoConfiguration.class, (String)"taotao-cloud-starter-openfeign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient.Builder okHttpClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool httpClientConnectionPool(FeignHttpClientProperties httpClientProperties) {
        int maxTotalConnections = httpClientProperties.getMaxConnections();
        long timeToLive = httpClientProperties.getTimeToLive();
        TimeUnit ttlUnit = httpClientProperties.getTimeToLiveUnit();
        return new ConnectionPool(maxTotalConnections, timeToLive, ttlUnit);
    }

    @Bean
    public OkHttpClient okHttpClient(OkHttpClient.Builder builder, ConnectionPool connectionPool, FeignHttpClientProperties httpClientProperties) {
        boolean followRedirects = httpClientProperties.isFollowRedirects();
        int connectTimeout = httpClientProperties.getConnectionTimeout();
        boolean disableSslValidation = httpClientProperties.isDisableSslValidation();
        Duration readTimeout = httpClientProperties.getOkHttp().getReadTimeout();
        if (disableSslValidation) {
            this.disableSsl(builder);
        }
        this.okHttpClient = builder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).followRedirects(followRedirects).readTimeout(readTimeout).connectionPool(connectionPool).build();
        return this.okHttpClient;
    }

    private void disableSsl(OkHttpClient.Builder builder) {
        try {
            DisableValidationTrustManager disabledTrustManager = new DisableValidationTrustManager();
            TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            SSLSocketFactory disabledSSLSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(disabledSSLSocketFactory, (X509TrustManager)disabledTrustManager);
            builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnames());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LogUtils.warn((String)"Error setting SSLSocketFactory in OKHttpClient", (Object[])new Object[]{e});
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    public OkHttpClient feignClient(OkHttpClient.Builder client) {
        return new OkHttpClient(client);
    }

    class DisableValidationTrustManager
    implements X509TrustManager {
        DisableValidationTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    class TrustAllHostnames
    implements HostnameVerifier {
        TrustAllHostnames() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

