/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.endpoint;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Endpoint(id="feignClients")
public class FeignClientEndpoint
implements SmartInitializingSingleton {
    private final ApplicationContext context;
    private final List<FeignClientInfo> clientList;

    public FeignClientEndpoint(ApplicationContext context) {
        this.context = context;
        this.clientList = new ArrayList<FeignClientInfo>();
    }

    @ReadOperation
    public List<FeignClientInfo> invoke() {
        return this.clientList;
    }

    public void afterSingletonsInstantiated() {
        this.clientList.addAll(FeignClientEndpoint.getClientList(this.context));
    }

    private static List<FeignClientInfo> getClientList(ApplicationContext context) {
        Map feignClientMap = context.getBeansWithAnnotation(FeignClient.class);
        ArrayList<FeignClientInfo> feignClientInfoList = new ArrayList<FeignClientInfo>();
        Set feignClientEntrySet = feignClientMap.entrySet();
        for (Map.Entry feignClientEntry : feignClientEntrySet) {
            Class<?>[] interfaces;
            Class<?> feignClientClass;
            FeignClient feignClientAnn;
            String beanName = (String)feignClientEntry.getKey();
            Object feignClientBean = feignClientEntry.getValue();
            if (feignClientBean == null || (feignClientAnn = (FeignClient)AnnotationUtils.findAnnotation(feignClientClass = feignClientBean.getClass(), FeignClient.class)) == null) continue;
            FeignClientInfo feignClientInfo = new FeignClientInfo();
            feignClientInfo.setBeanName(beanName);
            String serviceId = feignClientAnn.value();
            String contextId = feignClientAnn.contextId();
            String url = feignClientAnn.url();
            String path = feignClientAnn.path();
            feignClientInfo.setServiceId(serviceId);
            feignClientInfo.setContextId(contextId);
            feignClientInfo.setUrl(url);
            feignClientInfo.setPath(path);
            ArrayList<ClientInfo> clientInfoList = new ArrayList<ClientInfo>();
            for (Class<?> clientInterface : interfaces = feignClientClass.getInterfaces()) {
                Method[] methods;
                for (Method method : methods = clientInterface.getDeclaredMethods()) {
                    RequestMapping requestMapping;
                    if (method.isDefault() || (requestMapping = (RequestMapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, RequestMapping.class)) == null) continue;
                    clientInfoList.add(new ClientInfo(requestMapping.method(), requestMapping.value()));
                }
            }
            feignClientInfo.setClientList(clientInfoList);
            feignClientInfoList.add(feignClientInfo);
        }
        return feignClientInfoList;
    }

    public static class FeignClientInfo {
        private String beanName;
        private String serviceId;
        private String contextId;
        private String url;
        private String path;
        private List<ClientInfo> clientList;

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getContextId() {
            return this.contextId;
        }

        public void setContextId(String contextId) {
            this.contextId = contextId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<ClientInfo> getClientList() {
            return this.clientList;
        }

        public void setClientList(List<ClientInfo> clientList) {
            this.clientList = clientList;
        }
    }

    public static class ClientInfo {
        private final RequestMethod[] methods;
        private final String[] mappings;

        public ClientInfo(RequestMethod[] methods, String[] mappings) {
            this.methods = methods;
            this.mappings = mappings;
        }

        public RequestMethod[] getMethods() {
            return this.methods;
        }

        public String[] getMappings() {
            return this.mappings;
        }
    }
}

