/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.aspect;

import com.taotao.boot.common.exception.BaseException;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.cloud.openfeign.annotation.FeignRetry;
import feign.RetryableException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FeignRetryAspect {
    @Around(value="@annotation(com.taotao.cloud.openfeign.annotation.FeignRetry)")
    public Object retry(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = this.getCurrentMethod((JoinPoint)joinPoint);
        FeignRetry feignRetry = method.getAnnotation(FeignRetry.class);
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setBackOffPolicy(this.prepareBackOffPolicy(feignRetry));
        retryTemplate.setRetryPolicy((RetryPolicy)this.prepareSimpleRetryPolicy(feignRetry));
        return retryTemplate.execute(retryCallback -> {
            int retryCount = retryCallback.getRetryCount();
            LogUtils.info((String)"Sending request method: {}, max attempt: {}, delay: {}, retryCount: {}", (Object[])new Object[]{method.getName(), feignRetry.maxAttempt(), feignRetry.backoff().delay(), retryCount});
            return joinPoint.proceed(joinPoint.getArgs());
        });
    }

    private BackOffPolicy prepareBackOffPolicy(FeignRetry feignRetry) {
        if (feignRetry.backoff().multiplier() != 0.0) {
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            backOffPolicy.setInitialInterval(feignRetry.backoff().delay());
            backOffPolicy.setMaxInterval(feignRetry.backoff().maxDelay());
            backOffPolicy.setMultiplier(feignRetry.backoff().multiplier());
            return backOffPolicy;
        }
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(feignRetry.backoff().delay());
        return fixedBackOffPolicy;
    }

    private SimpleRetryPolicy prepareSimpleRetryPolicy(FeignRetry feignRetry) {
        HashMap<Class<? extends Throwable>, Boolean> policyMap = new HashMap<Class<? extends Throwable>, Boolean>();
        policyMap.put(RetryableException.class, true);
        policyMap.put(BaseException.class, true);
        for (Class<? extends Throwable> t : feignRetry.include()) {
            policyMap.put(t, true);
        }
        return new SimpleRetryPolicy(feignRetry.maxAttempt(), policyMap, true);
    }

    private Method getCurrentMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return signature.getMethod();
    }
}

