/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.cloud.openfeign.aspect.FeignRetryAspect;
import com.taotao.cloud.openfeign.feign.FeignErrorDecoder;
import com.taotao.cloud.openfeign.feign.FeignInnerContract;
import com.taotao.cloud.openfeign.feign.FeignRequestInterceptor;
import com.taotao.cloud.openfeign.feign.FeignResponseEntityDecoder;
import com.taotao.cloud.openfeign.formatter.DateFormatRegister;
import com.taotao.cloud.openfeign.properties.FeignProperties;
import com.taotao.cloud.openfeign.properties.LoadbalancerProperties;
import feign.Contract;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import feign.optionals.OptionalDecoder;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@EnableFeignClients(basePackages={"com.taotao.cloud.*.api.feign"})
@EnableConfigurationProperties(value={LoadbalancerProperties.class, FeignProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.feign", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FeignAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(FeignAutoConfiguration.class, (String)"taotao-cloud-starter-openfeign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public Contract contract() {
        return new FeignInnerContract();
    }

    @Bean
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public DateFormatRegister dateFormatRegister() {
        return new DateFormatRegister();
    }

    @Bean
    public Retryer retryer() {
        return new Retryer.Default();
    }

    @Bean
    public FeignRetryAspect feignRetryAspect() {
        return new FeignRetryAspect();
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder multipartFormEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SpringFormEncoder((Encoder)new SpringEncoder(messageConverters));
    }

    @Bean
    public Decoder feignDecoder(ObjectFactory<HttpMessageConverters> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        return new OptionalDecoder((Decoder)new FeignResponseEntityDecoder((Decoder)new SpringDecoder(messageConverters, customizers)));
    }

    @Bean
    public FeignErrorDecoder feignErrorDecoder() {
        return new FeignErrorDecoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={FeignRequestInterceptor.class})
    public RequestInterceptor feignRequestInterceptor() {
        LogUtils.trace((String)" Bean [Feign Request Interceptor] Auto Configure.", (Object[])new Object[0]);
        return new FeignRequestInterceptor();
    }

    @Bean
    public Request.Options options() {
        return new Request.Options(10L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS, true);
    }
}

