/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.feign;

import com.taotao.boot.common.holder.TenantContextHolder;
import com.taotao.boot.common.holder.TraceContextHolder;
import com.taotao.boot.common.holder.VersionContextHolder;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignRequestInterceptor
implements RequestInterceptor {
    protected List<String> requestHeaders = new ArrayList<String>();
    public static final List<String> HEADER_NAME_LIST = Arrays.asList("tenant", "sub_tenant", "userid", "account", "name", "gray_version", "x-trace-header", "X-Real-IP", "x-forwarded-for");

    @PostConstruct
    public void initialize() {
        this.requestHeaders.add("ttc-user-id-header");
        this.requestHeaders.add("ttc-user-name-header");
        this.requestHeaders.add("ttc-user-role-header");
        this.requestHeaders.add("ttc-user-role-header");
    }

    public void apply(RequestTemplate template) {
        String tenant;
        Map headers = template.headers();
        Set feignHeaderNames = headers.keySet();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            String token;
            ServletRequestAttributes attributes = (ServletRequestAttributes)requestAttributes;
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if (feignHeaderNames.contains(headerName)) continue;
                    String values = request.getHeader(headerName);
                    if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"Content-Length")) continue;
                    if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")) {
                        values = StringUtils.replace((String)values, (String)"", (String)String.valueOf(' '));
                    }
                    template.header(headerName, new String[]{values});
                }
            }
            if (StrUtil.isEmpty((CharSequence)(token = this.extractHeaderToken(request)))) {
                token = request.getParameter("access_token");
            }
            if (StrUtil.isNotEmpty((CharSequence)token)) {
                this.addHeader(template, "Authorization", "bearea " + token);
            }
        }
        if (StrUtil.isBlank((CharSequence)(tenant = TenantContextHolder.getTenant()))) {
            tenant = TraceUtils.getTtcTenantId();
        }
        this.addHeader(template, "ttc-tenant-id", StrUtil.isNotBlank((CharSequence)tenant) ? tenant : "1");
        String traceId = TraceContextHolder.getTraceId();
        if (StrUtil.isBlank((CharSequence)traceId)) {
            traceId = TraceUtils.getTtcTraceId();
        }
        this.addHeader(template, "ttc-trace-id", StrUtil.isNotBlank((CharSequence)traceId) ? traceId : IdGeneratorUtils.getIdStr());
        String version = VersionContextHolder.getVersion();
        if (StrUtil.isBlank((CharSequence)version)) {
            version = TraceUtils.getTtcVersion();
        }
        this.addHeader(template, "ttc-request-version", StrUtil.isNotBlank((CharSequence)version) ? version : "");
        this.addHeader(template, "ttc-from-inner", "true");
    }

    private String extractHeaderToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.startsWith("bearea")) continue;
            String authHeaderValue = value.substring("bearea".length()).trim();
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        return null;
    }

    private void addHeader(RequestTemplate template, String headerName, String headerValue) {
        Map headers = template.headers();
        if (StrUtil.isBlank((CharSequence)headerName) || StrUtil.isBlank((CharSequence)headerValue)) {
            return;
        }
        if (headers.containsKey(headerName)) {
            Collection headerValues = (Collection)headers.get(headerName);
            if (CollUtil.isEmpty((Collection)headerValues)) {
                template.header(headerName, new String[]{headerValue});
            }
            if (!headerValues.contains(headerValue)) {
                template.header(headerName, new String[]{headerValue});
            }
        } else {
            template.header(headerName, new String[]{headerValue});
        }
    }
}

