/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.http;

import com.taotao.cloud.openfeign.feign.FeignRequestInterceptor;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.dromara.hutool.core.util.ObjUtil;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestTemplateHeaderInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            FeignRequestInterceptor.HEADER_NAME_LIST.forEach(headerName -> {});
            return execution.execute(request, bytes);
        }
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        FeignRequestInterceptor.HEADER_NAME_LIST.forEach(headerName -> {
            if (ObjUtil.isNotEmpty((Object)httpServletRequest.getHeader(headerName))) {
                httpHeaders.add(headerName, httpServletRequest.getHeader(headerName));
            }
        });
        return execution.execute(request, bytes);
    }
}

