/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.openfeign.loadbalancer;

import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.taotao.boot.common.utils.log.LogUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.springframework.cache.Cache;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;
import org.springframework.stereotype.Component;

@Component
public class ServiceChangeNotifier
extends Subscriber<InstancesChangeEvent> {
    @Resource
    private LoadBalancerCacheManager defaultLoadBalancerCacheManager;

    @PostConstruct
    public void init() {
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void onEvent(InstancesChangeEvent event) {
        String serviceName = event.getServiceName();
        if (serviceName.contains(":")) {
            return;
        }
        String split = "@@";
        if (serviceName.contains(split)) {
            serviceName = serviceName.substring(serviceName.indexOf(split) + split.length());
        }
        LogUtils.info((String)"\u670d\u52a1\u4e0a\u4e0b\u7ebf: {}", (Object[])new Object[]{serviceName});
        Cache cache = this.defaultLoadBalancerCacheManager.getCache(CachingServiceInstanceListSupplier.SERVICE_INSTANCE_CACHE_NAME);
        if (cache != null) {
            cache.evictIfPresent((Object)serviceName);
        }
    }

    public Class<? extends Event> subscribeType() {
        return InstancesChangeEvent.class;
    }
}

