/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.service;

import com.taotao.cloud.oss.common.exception.UploadFileException;
import com.taotao.cloud.oss.common.model.UploadFileInfo;
import com.taotao.cloud.oss.common.service.UploadFileService;
import com.taotao.cloud.oss.common.util.FileUtil;
import java.io.File;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractUploadFileService
implements UploadFileService {
    public static final String UPLOAD_FILE_SPLIT = ".";
    public static final String UPLOAD_FILE_ERROR_MESSAGE = "\u7f3a\u5c11\u540e\u7f00\u540d";

    @Override
    public UploadFileInfo upload(File file) throws UploadFileException {
        UploadFileInfo uploadFileInfo = FileUtil.getFileInfo(file);
        if (!uploadFileInfo.getName().contains(UPLOAD_FILE_SPLIT)) {
            throw new UploadFileException(UPLOAD_FILE_ERROR_MESSAGE);
        }
        return this.uploadFile(file, uploadFileInfo);
    }

    @Override
    public UploadFileInfo upload(File file, String fileName) throws UploadFileException {
        UploadFileInfo uploadFileInfo = FileUtil.getFileInfo(file);
        if (!uploadFileInfo.getName().contains(UPLOAD_FILE_SPLIT)) {
            throw new UploadFileException(UPLOAD_FILE_ERROR_MESSAGE);
        }
        uploadFileInfo.setName(fileName);
        return this.uploadFile(file, uploadFileInfo);
    }

    @Override
    public UploadFileInfo upload(MultipartFile file) throws UploadFileException {
        UploadFileInfo uploadFileInfo = FileUtil.getMultipartFileInfo(file);
        if (!uploadFileInfo.getName().contains(UPLOAD_FILE_SPLIT)) {
            throw new UploadFileException(UPLOAD_FILE_ERROR_MESSAGE);
        }
        return this.uploadFile(file, uploadFileInfo);
    }

    @Override
    public UploadFileInfo upload(MultipartFile file, String fileName) throws UploadFileException {
        UploadFileInfo uploadFileInfo = FileUtil.getMultipartFileInfo(file);
        if (!uploadFileInfo.getName().contains(UPLOAD_FILE_SPLIT)) {
            throw new UploadFileException(UPLOAD_FILE_ERROR_MESSAGE);
        }
        uploadFileInfo.setName(fileName);
        return this.uploadFile(file, uploadFileInfo);
    }

    protected abstract UploadFileInfo uploadFile(MultipartFile var1, UploadFileInfo var2) throws UploadFileException;

    protected abstract UploadFileInfo uploadFile(File var1, UploadFileInfo var2) throws UploadFileException;
}

