/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.taotao.cloud.oss.common.storage.Downloader;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.FileStorageProperties;
import com.taotao.cloud.oss.common.storage.MockMultipartFile;
import com.taotao.cloud.oss.common.storage.MultipartFileWrapper;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.aspect.DeleteAspectChain;
import com.taotao.cloud.oss.common.storage.aspect.ExistsAspectChain;
import com.taotao.cloud.oss.common.storage.aspect.FileStorageAspect;
import com.taotao.cloud.oss.common.storage.aspect.UploadAspectChain;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import com.taotao.cloud.oss.common.storage.recorder.FileRecorder;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.web.multipart.MultipartFile;

public class FileStorageService
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(FileStorageService.class);
    private FileStorageService self;
    private FileRecorder fileRecorder;
    private CopyOnWriteArrayList<FileStorage> fileStorageList;
    private FileStorageProperties properties;
    private CopyOnWriteArrayList<FileStorageAspect> aspectList;

    public FileStorage getFileStorage() {
        return this.getFileStorage(this.properties.getDefaultPlatform());
    }

    public FileStorage getFileStorage(String platform) {
        for (FileStorage fileStorage : this.fileStorageList) {
            if (!fileStorage.getPlatform().equals(platform)) continue;
            return fileStorage;
        }
        return null;
    }

    public FileStorage getFileStorageVerify(FileInfo fileInfo) {
        FileStorage fileStorage = this.getFileStorage(fileInfo.getPlatform());
        if (fileStorage == null) {
            throw new FileStorageRuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01");
        }
        return fileStorage;
    }

    public FileInfo upload(UploadPretreatment pre) {
        FileStorage fileStorage;
        MultipartFileWrapper file = pre.getFileWrapper();
        if (file == null) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e3a null \uff01");
        }
        if (pre.getPlatform() == null) {
            throw new FileStorageRuntimeException("platform \u4e0d\u5141\u8bb8\u4e3a null \uff01");
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setCreateTime(LocalDateTime.now());
        fileInfo.setSize(file.getSize());
        fileInfo.setOriginalFilename(file.getOriginalFilename());
        fileInfo.setExt(FileNameUtil.getSuffix((String)file.getOriginalFilename()));
        fileInfo.setObjectId(pre.getObjectId());
        fileInfo.setObjectType(pre.getObjectType());
        fileInfo.setPath(pre.getPath());
        fileInfo.setPlatform(pre.getPlatform());
        fileInfo.setAttr(pre.getAttr());
        if (StrUtil.isNotBlank((CharSequence)pre.getSaveFilename())) {
            fileInfo.setFilename(pre.getSaveFilename());
        } else {
            fileInfo.setFilename(IdUtil.objectId() + (String)(StrUtil.isEmpty((CharSequence)fileInfo.getExt()) ? "" : "." + fileInfo.getExt()));
        }
        if (pre.getContentType() != null) {
            fileInfo.setContentType(pre.getContentType());
        } else if (pre.getFileWrapper().getContentType() != null) {
            fileInfo.setContentType(pre.getFileWrapper().getContentType());
        } else {
            fileInfo.setContentType(URLConnection.guessContentTypeFromName(fileInfo.getFilename()));
        }
        byte[] thumbnailBytes = pre.getThumbnailBytes();
        if (thumbnailBytes != null) {
            fileInfo.setThSize(Long.valueOf(thumbnailBytes.length));
            if (StrUtil.isNotBlank((CharSequence)pre.getSaveThFilename())) {
                fileInfo.setThFilename(pre.getSaveThFilename() + pre.getThumbnailSuffix());
            } else {
                fileInfo.setThFilename(fileInfo.getFilename() + pre.getThumbnailSuffix());
            }
            fileInfo.setThContentType(URLConnection.guessContentTypeFromName(fileInfo.getThFilename()));
        }
        if ((fileStorage = this.getFileStorage(pre.getPlatform())) == null) {
            throw new FileStorageRuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01");
        }
        return new UploadAspectChain(this.aspectList, (_fileInfo, _pre, _fileStorage, _fileRecorder) -> {
            if (_fileStorage.save(_fileInfo, _pre) && _fileRecorder.record(_fileInfo)) {
                return _fileInfo;
            }
            return null;
        }).next(fileInfo, pre, fileStorage, this.fileRecorder);
    }

    public FileInfo getFileInfoByUrl(String url) {
        return this.fileRecorder.getByUrl(url);
    }

    public boolean delete(String url) {
        return this.delete(this.getFileInfoByUrl(url));
    }

    public boolean delete(String url, Predicate<FileInfo> predicate) {
        return this.delete(this.getFileInfoByUrl(url), predicate);
    }

    public boolean delete(FileInfo fileInfo) {
        return this.delete(fileInfo, null);
    }

    public boolean delete(FileInfo fileInfo, Predicate<FileInfo> predicate) {
        if (fileInfo == null) {
            return true;
        }
        if (predicate != null && !predicate.test(fileInfo)) {
            return false;
        }
        FileStorage fileStorage = this.getFileStorage(fileInfo.getPlatform());
        if (fileStorage == null) {
            throw new FileStorageRuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01");
        }
        return new DeleteAspectChain(this.aspectList, (_fileInfo, _fileStorage, _fileRecorder) -> {
            if (_fileStorage.delete(_fileInfo)) {
                return _fileRecorder.delete(_fileInfo.getUrl());
            }
            return false;
        }).next(fileInfo, fileStorage, this.fileRecorder);
    }

    public boolean exists(String url) {
        return this.exists(this.getFileInfoByUrl(url));
    }

    public boolean exists(FileInfo fileInfo) {
        if (fileInfo == null) {
            return false;
        }
        return new ExistsAspectChain(this.aspectList, (_fileInfo, _fileStorage) -> _fileStorage.exists(_fileInfo)).next(fileInfo, this.getFileStorageVerify(fileInfo));
    }

    public Downloader download(FileInfo fileInfo) {
        return new Downloader(fileInfo, this.aspectList, this.getFileStorageVerify(fileInfo), 1);
    }

    public Downloader download(String url) {
        return this.download(this.getFileInfoByUrl(url));
    }

    public Downloader downloadTh(FileInfo fileInfo) {
        return new Downloader(fileInfo, this.aspectList, this.getFileStorageVerify(fileInfo), 2);
    }

    public Downloader downloadTh(String url) {
        return this.downloadTh(this.getFileInfoByUrl(url));
    }

    public UploadPretreatment of() {
        UploadPretreatment pre = new UploadPretreatment();
        pre.setFileStorageService(this.self);
        pre.setPlatform(this.properties.getDefaultPlatform());
        pre.setThumbnailSuffix(this.properties.getThumbnailSuffix());
        return pre;
    }

    public UploadPretreatment of(MultipartFile file) {
        UploadPretreatment pre = this.of();
        pre.setFileWrapper(new MultipartFileWrapper(file));
        return pre;
    }

    public UploadPretreatment of(byte[] bytes) {
        UploadPretreatment pre = this.of();
        pre.setFileWrapper(new MultipartFileWrapper(new MockMultipartFile("", bytes)));
        return pre;
    }

    public UploadPretreatment of(InputStream in) {
        try {
            UploadPretreatment pre = this.of();
            pre.setFileWrapper(new MultipartFileWrapper(new MockMultipartFile("", in)));
            return pre;
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u6839\u636e InputStream \u521b\u5efa\u4e0a\u4f20\u9884\u5904\u7406\u5668\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment of(File file) {
        try {
            UploadPretreatment pre = this.of();
            pre.setFileWrapper(new MultipartFileWrapper(new MockMultipartFile(file.getName(), file.getName(), URLConnection.guessContentTypeFromName(file.getName()), Files.newInputStream(file.toPath(), new OpenOption[0]))));
            return pre;
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u6839\u636e File \u521b\u5efa\u4e0a\u4f20\u9884\u5904\u7406\u5668\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment of(URL url) {
        try {
            String path;
            UploadPretreatment pre = this.of();
            URLConnection conn = url.openConnection();
            String name = "";
            String disposition = conn.getHeaderField("Content-Disposition");
            if (StrUtil.isNotBlank((CharSequence)disposition) && StrUtil.isBlank((CharSequence)(name = ReUtil.get((String)"filename=\"(.*?)\"", (CharSequence)disposition, (int)1)))) {
                name = StrUtil.subAfter((CharSequence)disposition, (CharSequence)"filename=", (boolean)true);
            }
            if (StrUtil.isBlank((CharSequence)name) && StrUtil.isNotBlank((CharSequence)(name = StrUtil.subSuf((CharSequence)(path = url.getPath()), (int)(path.lastIndexOf(47) + 1))))) {
                name = URLUtil.decode((String)name, (Charset)StandardCharsets.UTF_8);
            }
            pre.setFileWrapper(new MultipartFileWrapper(new MockMultipartFile(url.toString(), name, conn.getContentType(), conn.getInputStream())));
            return pre;
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u6839\u636e URL \u521b\u5efa\u4e0a\u4f20\u9884\u5904\u7406\u5668\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment of(URI uri) {
        try {
            return this.of(uri.toURL());
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u6839\u636e URI \u521b\u5efa\u4e0a\u4f20\u9884\u5904\u7406\u5668\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment of(String url) {
        try {
            return this.of(URLUtil.url((String)url));
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u6839\u636e url\uff1a" + url + " \u521b\u5efa\u4e0a\u4f20\u9884\u5904\u7406\u5668\u5931\u8d25\uff01", e);
        }
    }

    public void destroy() {
        for (FileStorage fileStorage : this.fileStorageList) {
            try {
                fileStorage.close();
                log.error("\u9500\u6bc1\u5b58\u50a8\u5e73\u53f0 {} \u6210\u529f", (Object)fileStorage.getPlatform());
            }
            catch (Exception e) {
                log.error("\u9500\u6bc1\u5b58\u50a8\u5e73\u53f0 {} \u5931\u8d25\uff0c{}", new Object[]{fileStorage.getPlatform(), e.getMessage(), e});
            }
        }
    }

    public FileStorageService getSelf() {
        return this.self;
    }

    public FileRecorder getFileRecorder() {
        return this.fileRecorder;
    }

    public CopyOnWriteArrayList<FileStorage> getFileStorageList() {
        return this.fileStorageList;
    }

    public FileStorageProperties getProperties() {
        return this.properties;
    }

    public CopyOnWriteArrayList<FileStorageAspect> getAspectList() {
        return this.aspectList;
    }

    public void setSelf(FileStorageService self) {
        this.self = self;
    }

    public void setFileRecorder(FileRecorder fileRecorder) {
        this.fileRecorder = fileRecorder;
    }

    public void setFileStorageList(CopyOnWriteArrayList<FileStorage> fileStorageList) {
        this.fileStorageList = fileStorageList;
    }

    public void setProperties(FileStorageProperties properties) {
        this.properties = properties;
    }

    public void setAspectList(CopyOnWriteArrayList<FileStorageAspect> aspectList) {
        this.aspectList = aspectList;
    }
}

