/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage;

import com.taotao.cloud.oss.common.storage.ProgressListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private boolean readFlag;
    private long progressSize;
    private final long allSize;
    private final ProgressListener listener;

    public ProgressInputStream(InputStream in, ProgressListener listener, long allSize) {
        super(in);
        this.listener = listener;
        this.allSize = allSize;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.progress(skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.progress(b == -1 ? -1L : 1L);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.readFlag) {
            this.readFlag = true;
            this.listener.start();
        }
        int bytes = super.read(b, off, len);
        this.progress(bytes);
        return bytes;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    protected void progress(long size) {
        if (size > 0L) {
            this.listener.progress(this.progressSize += size, this.allSize);
        } else if (size < 0L) {
            this.listener.finish();
        }
    }
}

