/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Dict;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.FileStorageService;
import com.taotao.cloud.oss.common.storage.MockMultipartFile;
import com.taotao.cloud.oss.common.storage.MultipartFileWrapper;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.web.multipart.MultipartFile;

public class UploadPretreatment {
    private FileStorageService fileStorageService;
    private String platform;
    private MultipartFileWrapper fileWrapper;
    private byte[] thumbnailBytes;
    private String thumbnailSuffix;
    private String objectId;
    private String objectType;
    private String path = "";
    private String saveFilename;
    private String saveThFilename;
    private String contentType;
    private String thContentType;
    private Dict attr;

    public UploadPretreatment setObjectId(Object objectId) {
        this.objectId = objectId == null ? null : objectId.toString();
        return this;
    }

    public String getName() {
        return this.fileWrapper.getName();
    }

    public UploadPretreatment setName(String name) {
        this.fileWrapper.setName(name);
        return this;
    }

    public String getOriginalFilename() {
        return this.fileWrapper.getOriginalFilename();
    }

    public UploadPretreatment setOriginalFilename(String originalFilename) {
        this.fileWrapper.setOriginalFilename(originalFilename);
        return this;
    }

    public Dict getAttr() {
        if (this.attr == null) {
            this.attr = new Dict();
        }
        return this.attr;
    }

    public UploadPretreatment putAttr(String key, Object value) {
        this.getAttr().put(key, value);
        return this;
    }

    public UploadPretreatment image(Consumer<Thumbnails.Builder<? extends InputStream>> consumer) {
        UploadPretreatment uploadPretreatment;
        block8: {
            InputStream in = this.fileWrapper.getInputStream();
            try {
                Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{in});
                consumer.accept((Thumbnails.Builder<? extends InputStream>)builder);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                builder.toOutputStream((OutputStream)out);
                MultipartFile mf = this.fileWrapper.getMultipartFile();
                this.fileWrapper.setMultipartFile(new MockMultipartFile(mf.getName(), mf.getOriginalFilename(), null, out.toByteArray()));
                uploadPretreatment = this;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileStorageRuntimeException("\u56fe\u7247\u5904\u7406\u5931\u8d25\uff01", e);
                }
            }
            in.close();
        }
        return uploadPretreatment;
    }

    public UploadPretreatment image(int width, int height) {
        return this.image(th -> th.size(width, height));
    }

    public UploadPretreatment image() {
        return this.image(th -> th.size(200, 200));
    }

    public UploadPretreatment clearThumbnail() {
        this.thumbnailBytes = null;
        return this;
    }

    public UploadPretreatment thumbnail(Consumer<Thumbnails.Builder<? extends InputStream>> consumer) {
        try {
            return this.thumbnail(consumer, this.thumbnailBytes != null ? new ByteArrayInputStream(this.thumbnailBytes) : this.fileWrapper.getInputStream());
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment thumbnail(Consumer<Thumbnails.Builder<? extends InputStream>> consumer, MultipartFile file) {
        try {
            return this.thumbnail(consumer, file.getInputStream());
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", e);
        }
    }

    public UploadPretreatment thumbnail(Consumer<Thumbnails.Builder<? extends InputStream>> consumer, InputStream in) {
        try {
            Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{in});
            builder.outputFormat(FileNameUtil.extName((String)this.thumbnailSuffix));
            consumer.accept((Thumbnails.Builder<? extends InputStream>)builder);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)out);
            this.thumbnailBytes = out.toByteArray();
            UploadPretreatment uploadPretreatment = this;
            return uploadPretreatment;
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", e);
        }
        finally {
            IoUtil.close((Closeable)in);
        }
    }

    public UploadPretreatment thumbnail(int width, int height) {
        return this.thumbnail(th -> th.size(width, height));
    }

    public UploadPretreatment thumbnail() {
        return this.thumbnail(200, 200);
    }

    public FileInfo upload() {
        return this.fileStorageService.upload(this);
    }

    public FileStorageService getFileStorageService() {
        return this.fileStorageService;
    }

    public String getPlatform() {
        return this.platform;
    }

    public MultipartFileWrapper getFileWrapper() {
        return this.fileWrapper;
    }

    public byte[] getThumbnailBytes() {
        return this.thumbnailBytes;
    }

    public String getThumbnailSuffix() {
        return this.thumbnailSuffix;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getPath() {
        return this.path;
    }

    public String getSaveFilename() {
        return this.saveFilename;
    }

    public String getSaveThFilename() {
        return this.saveThFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getThContentType() {
        return this.thContentType;
    }

    public UploadPretreatment setFileStorageService(FileStorageService fileStorageService) {
        this.fileStorageService = fileStorageService;
        return this;
    }

    public UploadPretreatment setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public UploadPretreatment setFileWrapper(MultipartFileWrapper fileWrapper) {
        this.fileWrapper = fileWrapper;
        return this;
    }

    public UploadPretreatment setThumbnailBytes(byte[] thumbnailBytes) {
        this.thumbnailBytes = thumbnailBytes;
        return this;
    }

    public UploadPretreatment setThumbnailSuffix(String thumbnailSuffix) {
        this.thumbnailSuffix = thumbnailSuffix;
        return this;
    }

    public UploadPretreatment setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public UploadPretreatment setPath(String path) {
        this.path = path;
        return this;
    }

    public UploadPretreatment setSaveFilename(String saveFilename) {
        this.saveFilename = saveFilename;
        return this;
    }

    public UploadPretreatment setSaveThFilename(String saveThFilename) {
        this.saveThFilename = saveThFilename;
        return this;
    }

    public UploadPretreatment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public UploadPretreatment setThContentType(String thContentType) {
        this.thContentType = thContentType;
        return this;
    }

    public UploadPretreatment setAttr(Dict attr) {
        this.attr = attr;
        return this;
    }
}

