/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.aspect;

import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.aspect.DeleteAspectChainCallback;
import com.taotao.cloud.oss.common.storage.aspect.FileStorageAspect;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import com.taotao.cloud.oss.common.storage.recorder.FileRecorder;
import java.util.Iterator;

public class DeleteAspectChain {
    private DeleteAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public DeleteAspectChain(Iterable<FileStorageAspect> aspects, DeleteAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public boolean next(FileInfo fileInfo, FileStorage fileStorage, FileRecorder fileRecorder) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().deleteAround(this, fileInfo, fileStorage, fileRecorder);
        }
        return this.callback.run(fileInfo, fileStorage, fileRecorder);
    }

    public DeleteAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(DeleteAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

