/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.aspect;

import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.aspect.DownloadAspectChainCallback;
import com.taotao.cloud.oss.common.storage.aspect.FileStorageAspect;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;

public class DownloadAspectChain {
    private DownloadAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public DownloadAspectChain(Iterable<FileStorageAspect> aspects, DownloadAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public void next(FileInfo fileInfo, FileStorage fileStorage, Consumer<InputStream> consumer) {
        if (this.aspectIterator.hasNext()) {
            this.aspectIterator.next().downloadAround(this, fileInfo, fileStorage, consumer);
        } else {
            this.callback.run(fileInfo, fileStorage, consumer);
        }
    }

    public DownloadAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(DownloadAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

