/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.aspect;

import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.aspect.ExistsAspectChainCallback;
import com.taotao.cloud.oss.common.storage.aspect.FileStorageAspect;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.util.Iterator;

public class ExistsAspectChain {
    private ExistsAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public ExistsAspectChain(Iterable<FileStorageAspect> aspects, ExistsAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public boolean next(FileInfo fileInfo, FileStorage fileStorage) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().existsAround(this, fileInfo, fileStorage);
        }
        return this.callback.run(fileInfo, fileStorage);
    }

    public ExistsAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(ExistsAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

