/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.platform;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpMode;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class FtpFileStorage
implements FileStorage {
    private String host;
    private int port;
    private String user;
    private String password;
    private Charset charset;
    private long connectionTimeout;
    private long soTimeout;
    private String serverLanguageCode;
    private String systemKey;
    private Boolean isActive = false;
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;

    public Ftp getClient() {
        FtpConfig config = FtpConfig.create().setHost(this.host).setPort(this.port).setUser(this.user).setPassword(this.password).setCharset(this.charset).setConnectionTimeout(this.connectionTimeout).setSoTimeout(this.soTimeout).setServerLanguageCode(this.serverLanguageCode).setSystemKey(this.systemKey);
        return new Ftp(config, this.isActive != false ? FtpMode.Active : FtpMode.Passive);
    }

    @Override
    public void close() {
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        Ftp client = this.getClient();
        try {
            boolean bl;
            block14: {
                InputStream in = pre.getFileWrapper().getInputStream();
                try {
                    client.upload(this.getAbsolutePath(this.basePath + fileInfo.getPath()), fileInfo.getFilename(), in);
                    byte[] thumbnailBytes = pre.getThumbnailBytes();
                    if (thumbnailBytes != null) {
                        String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                        fileInfo.setThUrl(this.domain + newThFileKey);
                        client.upload(this.getAbsolutePath(this.basePath + fileInfo.getPath()), fileInfo.getThFilename(), (InputStream)new ByteArrayInputStream(thumbnailBytes));
                    }
                    bl = true;
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IORuntimeException | IOException e) {
                        try {
                            client.delFile(this.getAbsolutePath(newFileKey));
                        }
                        catch (IORuntimeException iORuntimeException) {
                            // empty catch block
                        }
                        throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
                    }
                }
                in.close();
            }
            return bl;
        }
        finally {
            IoUtil.close((Closeable)client);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        boolean bl;
        block9: {
            Ftp client = this.getClient();
            try {
                if (fileInfo.getThFilename() != null) {
                    client.delFile(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
                }
                client.delFile(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IORuntimeException | IOException e) {
                    throw new FileStorageRuntimeException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        boolean bl;
        block8: {
            Ftp client = this.getClient();
            try {
                bl = client.existFile(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IORuntimeException | IOException e) {
                    throw new FileStorageRuntimeException("\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Ftp client = this.getClient();){
            client.cd(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()));
            try (InputStream in = client.getClient().retrieveFileStream(fileInfo.getFilename());){
                if (in == null) {
                    throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01platform\uff1a" + fileInfo);
                }
                consumer.accept(in);
            }
        }
        catch (IORuntimeException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (Ftp client = this.getClient();){
            client.cd(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()));
            try (InputStream in = client.getClient().retrieveFileStream(fileInfo.getThFilename());){
                if (in == null) {
                    throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01platform\uff1a" + fileInfo);
                }
                consumer.accept(in);
            }
        }
        catch (IORuntimeException | IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getSoTimeout() {
        return this.soTimeout;
    }

    public String getServerLanguageCode() {
        return this.serverLanguageCode;
    }

    public String getSystemKey() {
        return this.systemKey;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(long soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setServerLanguageCode(String serverLanguageCode) {
        this.serverLanguageCode = serverLanguageCode;
    }

    public void setSystemKey(String systemKey) {
        this.systemKey = systemKey;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }
}

