/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.obs.services.ObsClient;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class HuaweiObsFileStorage
implements FileStorage {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private String bucketName;
    private String domain;
    private String basePath;
    private ObsClient client;

    public ObsClient getClient() {
        if (this.client == null) {
            this.client = new ObsClient(this.accessKey, this.secretKey, this.endPoint);
        }
        return this.client;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.client);
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block9: {
            String newFileKey = this.basePath + pre.getPath() + fileInfo.getFilename();
            fileInfo.setBasePath(this.basePath);
            fileInfo.setUrl(this.domain + newFileKey);
            ObsClient client = this.getClient();
            InputStream in = pre.getFileWrapper().getInputStream();
            try {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(fileInfo.getSize());
                metadata.setContentType(fileInfo.getContentType());
                client.putObject(this.bucketName, newFileKey, in, metadata);
                byte[] thumbnailBytes = pre.getThumbnailBytes();
                if (thumbnailBytes != null) {
                    String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    ObjectMetadata thMetadata = new ObjectMetadata();
                    thMetadata.setContentLength(Long.valueOf(thumbnailBytes.length));
                    thMetadata.setContentType(fileInfo.getThContentType());
                    client.putObject(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), thMetadata);
                }
                bl = true;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    client.deleteObject(this.bucketName, newFileKey);
                    throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        ObsClient client = this.getClient();
        if (fileInfo.getThFilename() != null) {
            client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        }
        client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        return true;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        return this.getClient().doesObjectExist(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        ObsObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        ObsObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setClient(ObsClient client) {
        this.client = client;
    }
}

