/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.platform;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class LocalPlusFileStorage
implements FileStorage {
    private String basePath;
    private String storagePath;
    private String platform;
    private String domain;

    @Override
    public void close() {
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        try {
            File newFile = FileUtil.touch((String)this.getAbsolutePath(newFileKey));
            pre.getFileWrapper().transferTo(newFile);
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                FileUtil.writeBytes((byte[])thumbnailBytes, (String)this.getAbsolutePath(newThFileKey));
            }
            return true;
        }
        catch (IOException e) {
            FileUtil.del((String)this.getAbsolutePath(newFileKey));
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        if (fileInfo.getThFilename() != null) {
            FileUtil.del((String)this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
        }
        return FileUtil.del((String)this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        return new File(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename())).exists();
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (BufferedInputStream in = FileUtil.getInputStream((String)this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (BufferedInputStream in = FileUtil.getInputStream((String)this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

