/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class SftpFileStorage
implements FileStorage {
    private String host;
    private int port;
    private String user;
    private String password;
    private String privateKeyPath;
    private Charset charset;
    private long connectionTimeout;
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;

    public Sftp getClient() {
        Session session = null;
        try {
            if (StrUtil.isNotBlank((CharSequence)this.privateKeyPath)) {
                byte[] passphrase = StrUtil.isBlank((CharSequence)this.password) ? null : this.password.getBytes(StandardCharsets.UTF_8);
                JSch jsch = new JSch();
                byte[] privateKey = IoUtil.readBytes((InputStream)URLUtil.url((String)this.privateKeyPath).openStream());
                jsch.addIdentity(this.privateKeyPath, privateKey, null, passphrase);
                session = JschUtil.createSession((JSch)jsch, (String)this.host, (int)this.port, (String)this.user);
                session.connect((int)this.connectionTimeout);
            } else {
                session = JschUtil.openSession((String)this.host, (int)this.port, (String)this.user, (String)this.password, (int)((int)this.connectionTimeout));
            }
            return new Sftp(session, this.charset, this.connectionTimeout);
        }
        catch (Exception e) {
            JschUtil.close(session);
            throw new FileStorageRuntimeException("SFTP\u8fde\u63a5\u5931\u8d25\uff01platform\uff1a" + this.platform, e);
        }
    }

    @Override
    public void close() {
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        Sftp client = this.getClient();
        try {
            boolean bl;
            block15: {
                InputStream in = pre.getFileWrapper().getInputStream();
                try {
                    String path = this.getAbsolutePath(this.basePath + fileInfo.getPath());
                    if (!client.exist(path)) {
                        client.mkDirs(path);
                    }
                    client.upload(path, fileInfo.getFilename(), in);
                    byte[] thumbnailBytes = pre.getThumbnailBytes();
                    if (thumbnailBytes != null) {
                        String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                        fileInfo.setThUrl(this.domain + newThFileKey);
                        client.upload(path, fileInfo.getThFilename(), (InputStream)new ByteArrayInputStream(thumbnailBytes));
                    }
                    bl = true;
                    if (in == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JschRuntimeException | IOException e) {
                        try {
                            client.delFile(this.getAbsolutePath(newFileKey));
                        }
                        catch (JschRuntimeException jschRuntimeException) {
                            // empty catch block
                        }
                        throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
                    }
                }
                in.close();
            }
            return bl;
        }
        finally {
            IoUtil.close((Closeable)client);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        boolean bl;
        block9: {
            Sftp client = this.getClient();
            try {
                if (fileInfo.getThFilename() != null) {
                    this.delFile(client, this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
                }
                this.delFile(client, this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JschRuntimeException e) {
                    throw new FileStorageRuntimeException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
                }
            }
            client.close();
        }
        return bl;
    }

    public void delFile(Sftp client, String filename) {
        block2: {
            try {
                client.delFile(filename);
            }
            catch (JschRuntimeException e) {
                if (e.getCause() instanceof SftpException && ((SftpException)e.getCause()).id == 2) break block2;
                throw e;
            }
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        boolean bl;
        block8: {
            Sftp client = this.getClient();
            try {
                bl = client.exist(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JschRuntimeException e) {
                    throw new FileStorageRuntimeException("\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Sftp client = this.getClient();
             InputStream in = client.getClient().get(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));){
            consumer.accept(in);
        }
        catch (JschRuntimeException | SftpException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (Sftp client = this.getClient();
             InputStream in = client.getClient().get(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()) + fileInfo.getThFilename());){
            consumer.accept(in);
        }
        catch (JschRuntimeException | SftpException | IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }
}

