/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.oss.common.storage.FileInfo;
import com.taotao.cloud.oss.common.storage.UploadPretreatment;
import com.taotao.cloud.oss.common.storage.exception.FileStorageRuntimeException;
import com.taotao.cloud.oss.common.storage.platform.FileStorage;
import com.upyun.RestManager;
import com.upyun.UpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class UpyunUssFileStorage
implements FileStorage {
    private String platform;
    private String username;
    private String password;
    private String bucketName;
    private String domain;
    private String basePath;
    private RestManager client;

    public RestManager getClient() {
        if (this.client == null) {
            this.client = new RestManager(this.bucketName, this.username, this.password);
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block20: {
            String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
            fileInfo.setBasePath(this.basePath);
            fileInfo.setUrl(this.domain + newFileKey);
            RestManager manager = this.getClient();
            InputStream in = pre.getFileWrapper().getInputStream();
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getContentType());
                try (Response result = manager.writeFile(newFileKey, in, params);){
                    if (!result.isSuccessful()) {
                        throw new UpException(result.toString());
                    }
                }
                byte[] thumbnailBytes = pre.getThumbnailBytes();
                if (thumbnailBytes != null) {
                    String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    HashMap<String, String> thParams = new HashMap<String, String>();
                    thParams.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getThContentType());
                    Response thResult = manager.writeFile(newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), thParams);
                    if (!thResult.isSuccessful()) {
                        throw new UpException(thResult.toString());
                    }
                }
                bl = true;
                if (in == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UpException | IOException e) {
                    try {
                        manager.deleteFile(newFileKey, null).close();
                    }
                    catch (UpException | IOException throwable3) {
                        // empty catch block
                    }
                    throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
                }
            }
            in.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(FileInfo fileInfo) {
        RestManager manager = this.getClient();
        String file = fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename();
        String thFile = fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename();
        try (Response ignored = fileInfo.getThFilename() != null ? manager.deleteFile(thFile, null) : null;){
            boolean bl;
            block14: {
                Response ignored2 = manager.deleteFile(file, null);
                try {
                    bl = true;
                    if (ignored2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return bl;
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        boolean bl;
        block8: {
            Response response = this.getClient().getFileInfo(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
            try {
                bl = StrUtil.isNotBlank((CharSequence)response.header("x-upyun-file-size"));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UpException | IOException e) {
                    throw new FileStorageRuntimeException("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Response response = this.getClient().readFile(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u7ed3\u679c\u4e3a null \uff01fileInfo\uff1a" + fileInfo);
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (Response response = this.getClient().readFile(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u7ed3\u679c\u4e3a null \uff01fileInfo\uff1a" + fileInfo);
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setClient(RestManager client) {
        this.client = client;
    }
}

