/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.oss.common.exception.UploadFileException;
import com.taotao.cloud.oss.common.exception.UploadFileTypeException;
import com.taotao.cloud.oss.common.model.UploadFileInfo;
import com.taotao.cloud.oss.common.util.MimeTypeUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public static final String UPLOAD_FILE_PARSE_ERROR_MESSAGE = "\u89e3\u6790\u6587\u4ef6\u5931\u8d25";
    public static final String UPLOAD_FILE_SAVE_ERROR_MESSAGE = "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25";
    public static final String UPLOAD_FILE_FORMAT_ERROR_MESSAGE = "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef";
    public static final String UPLOAD_FILE_DATA_FORMAT = "yyyy/MM/dd/HH/mm";
    public static final String UPLOAD_FILE_TOO_BIG = "\u6587\u4ef6\u8fc7\u5927";
    private static final int BUFFER_SIZE = 2048;

    private FileUtil() {
    }

    public static UploadFileInfo getMultipartFileInfo(MultipartFile multipartFile) {
        try {
            UploadFileInfo uploadFileInfo = new UploadFileInfo();
            String md5 = FileUtil.fileMd5(multipartFile.getInputStream());
            uploadFileInfo.setFileMd5(md5);
            String originalFilename = multipartFile.getOriginalFilename();
            uploadFileInfo.setOriginalFileName(originalFilename);
            assert (originalFilename != null);
            File file = new File(originalFilename);
            cn.hutool.core.io.FileUtil.writeFromStream((InputStream)multipartFile.getInputStream(), (File)file);
            String extName = cn.hutool.core.io.FileUtil.extName((File)file);
            uploadFileInfo.setName(FileUtil.extractFilename(originalFilename, extName));
            uploadFileInfo.setContentType(multipartFile.getContentType());
            uploadFileInfo.setImg(FileUtil.isImage(file));
            uploadFileInfo.setSize(multipartFile.getSize());
            uploadFileInfo.setFileType(FileTypeUtil.getType((InputStream)multipartFile.getInputStream()));
            return uploadFileInfo;
        }
        catch (IOException e) {
            throw new UploadFileException(UPLOAD_FILE_PARSE_ERROR_MESSAGE);
        }
    }

    public static UploadFileInfo getFileInfo(File file) {
        try {
            UploadFileInfo uploadFileInfo = new UploadFileInfo();
            String md5 = FileUtil.fileMd5(new FileInputStream(file));
            uploadFileInfo.setOriginalFileName(file.getName());
            uploadFileInfo.setName(file.getName());
            uploadFileInfo.setFileMd5(md5);
            uploadFileInfo.setContentType(new MimetypesFileTypeMap().getContentType(file));
            uploadFileInfo.setImg(FileUtil.isImage(file));
            uploadFileInfo.setSize(cn.hutool.core.io.FileUtil.size((File)file));
            uploadFileInfo.setFileType(cn.hutool.core.io.FileUtil.getType((File)file));
            return uploadFileInfo;
        }
        catch (Exception e) {
            throw new UploadFileException(UPLOAD_FILE_PARSE_ERROR_MESSAGE);
        }
    }

    public static String fileMd5(InputStream inputStream) {
        return DigestUtil.md5Hex((InputStream)inputStream);
    }

    public static String saveFile(MultipartFile file, String path) {
        try {
            File targetFile = new File(path);
            if (targetFile.exists()) {
                return path;
            }
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            file.transferTo(targetFile);
            return path;
        }
        catch (Exception e) {
            LogUtils.error((String)UPLOAD_FILE_SAVE_ERROR_MESSAGE, (Object[])new Object[]{e});
            return null;
        }
    }

    public static boolean deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            File[] files;
            boolean flag = file.delete();
            if (flag && ((files = file.getParentFile().listFiles()) == null || files.length == 0)) {
                file.getParentFile().delete();
            }
            return flag;
        }
        return false;
    }

    public static Boolean validType(MultipartFile file, String[] acceptTypes) {
        if (ArrayUtil.isEmpty((Object[])acceptTypes)) {
            return Boolean.TRUE;
        }
        try {
            String type = FileTypeUtil.getType((InputStream)file.getInputStream());
            if (StrUtil.isBlank((CharSequence)type)) {
                type = cn.hutool.core.io.FileUtil.extName((String)file.getOriginalFilename());
            }
            if (ArrayUtil.contains((Object[])acceptTypes, (Object)type)) {
                return Boolean.TRUE;
            }
            throw new UploadFileTypeException(UPLOAD_FILE_FORMAT_ERROR_MESSAGE);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UploadFileTypeException(UPLOAD_FILE_FORMAT_ERROR_MESSAGE);
        }
    }

    public static String extractFilename(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String extension = FileUtil.getExtension(file);
        return FileUtil.extractFilename(fileName, extension);
    }

    public static String extractFilename(String fileName, String extension) {
        return DateUtil.format((Date)new Date(), (String)UPLOAD_FILE_DATA_FORMAT) + "/" + FileUtil.encodingFilename(fileName) + "." + extension;
    }

    private static String encodingFilename(String fileName) {
        fileName = fileName.replace("_", " ");
        fileName = SecureUtil.md5().digestHex(fileName + System.nanoTime() + "tt");
        return fileName;
    }

    public static String getExtension(MultipartFile file) {
        String extension = cn.hutool.core.io.FileUtil.extName((String)file.getOriginalFilename());
        if (StringUtils.isEmpty((String)extension)) {
            extension = MimeTypeUtil.getExtension(Objects.requireNonNull(file.getContentType()));
        }
        return extension;
    }

    public static boolean isImage(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            BufferedImage image = ImageIO.read(file);
            return image != null && image.getWidth() > 0 && image.getHeight() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isImage(MultipartFile file) {
        if (file == null) {
            return false;
        }
        try {
            BufferedImage image = ImageIO.read(file.getInputStream());
            return image != null && image.getWidth() > 0 && image.getHeight() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] getFileByteArray(File file) {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            LogUtils.error((String)UPLOAD_FILE_TOO_BIG, (Object[])new Object[0]);
            return null;
        }
        byte[] buffer = null;
        try (FileInputStream fi = new FileInputStream(file);){
            int offset;
            int numRead;
            buffer = new byte[(int)fileSize];
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        byte[] buffer = new byte[8192];
        try (FileInputStream fis = new FileInputStream(file);
             OutputStream os = item.getOutputStream();){
            int bytesRead;
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MultipartFile fileToMultipartFileByMock(File file) {
        MockMultipartFile multipartFile;
        try {
            FileInputStream input = new FileInputStream(file);
            multipartFile = new MockMultipartFile("file", file.getName(), "text/plain", IOUtils.toByteArray((InputStream)input));
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e);
        }
        return multipartFile;
    }

    public static File multipartFileToFile(String path, MultipartFile multipartFile) {
        File file = new File(path);
        try {
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e);
        }
        return file;
    }

    public static boolean fileIsExists(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static void toZip(String outDir, boolean keepDirStructure, String ... srcDir) {
        try {
            FileOutputStream out = new FileOutputStream(new File(outDir));
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(out);
                ArrayList<File> sourceFileList = new ArrayList<File>();
                for (String dir : srcDir) {
                    File sourceFile = new File(dir);
                    sourceFileList.add(sourceFile);
                }
                FileUtil.compress(sourceFileList, zos, keepDirStructure);
            }
            catch (Exception e) {
                throw new RuntimeException("zip error from ZipUtils", e);
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u538b\u7f29\u5931\u8d25:{}", (Object[])new Object[]{e.getMessage()});
        }
    }

    private static void compress(List<File> sourceFileList, ZipOutputStream zos, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        for (File sourceFile : sourceFileList) {
            String name = sourceFile.getName();
            if (sourceFile.isFile()) {
                int len;
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
                continue;
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (!keepDirStructure) continue;
                zos.putNextEntry(new ZipEntry(name + "/"));
                zos.closeEntry();
                continue;
            }
            for (File file : listFiles) {
                if (keepDirStructure) {
                    FileUtil.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                    continue;
                }
                FileUtil.compress(file, zos, file.getName(), keepDirStructure);
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        FileUtil.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    FileUtil.compress(file, zos, file.getName(), keepDirStructure);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream inputStream, String path, String fileName) {
        OutputStream os = null;
        try {
            int len;
            byte[] bs = new byte[1024];
            File tempFile = new File(path);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            String newFileName = tempFile.getPath() + File.separator + fileName;
            LogUtils.info((String)("\u4fdd\u5b58\u6587\u4ef6\uff1a" + newFileName), (Object[])new Object[0]);
            os = new FileOutputStream(newFileName);
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u751f\u6210excel\u5931\u8d25", (Object[])new Object[0]);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                inputStream.close();
            }
            catch (IOException e) {
                LogUtils.error((String)("\u5173\u95ed\u94fe\u63a5\u5931\u8d25" + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream inputStream, String path, String fileName) {
        OutputStream os = null;
        long dateStr = System.currentTimeMillis();
        try {
            int len;
            byte[] bs = new byte[1024];
            File tempFile = new File(path);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            String newFileName = tempFile.getPath() + File.separator + fileName;
            LogUtils.info((String)("\u4fdd\u5b58\u6587\u4ef6\uff1a" + newFileName), (Object[])new Object[0]);
            os = new FileOutputStream(newFileName);
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u751f\u6210excel\u5931\u8d25", (Object[])new Object[0]);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                inputStream.close();
            }
            catch (IOException e) {
                LogUtils.error((String)("\u5173\u95ed\u94fe\u63a5\u5931\u8d25" + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }
}

