/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.util;

import com.taotao.cloud.common.utils.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClientUtil {
    public static final String FTP_CLIENT_CONNECTION_ERROR_MESSAGE = "FTPClient\u8fde\u63a5\u5931\u8d25";
    public static final String FTP_CLIENT_INIT_ERROR_MESSAGE = "FTP\u521d\u59cb\u5316\u5f02\u5e38: ";
    public static final String FTP_CLIENT_DESTORY_ERROR_MESSAGE = "FTP\u6ce8\u9500\u5f02\u5e38: ";
    private final String host;
    private final String port;
    private final String username;
    private final String passwd;
    private FTPClient client = null;
    private boolean isLogin = false;
    private InputStream input = null;
    private String remoteDir;
    private String ftpHome = null;
    private String controlEncoding = null;

    public FtpClientUtil(String host, String port, String username, String passwd, String remoteDir) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.passwd = passwd;
        this.remoteDir = remoteDir;
        this.init();
    }

    public FtpClientUtil(String host, String port, String username, String passwd) {
        this(host, port, username, passwd, null);
    }

    private void init() {
        try {
            this.client = new FTPClient();
            this.controlEncoding = this.client.getControlEncoding();
            this.client.connect(this.host, Integer.parseInt(this.port));
            this.isLogin = this.client.login(this.username, this.passwd);
            int reply = this.client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.isLogin = false;
                this.destroy();
                LogUtils.error((String)FTP_CLIENT_CONNECTION_ERROR_MESSAGE, (Object[])new Object[0]);
            } else {
                this.client.setFileType(2);
                this.ftpHome = this.client.printWorkingDirectory();
                this.client.makeDirectory(this.remoteDir);
                this.client.changeWorkingDirectory(this.remoteDir);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)(FTP_CLIENT_INIT_ERROR_MESSAGE + e.getMessage()), (Object[])new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.logout();
            return;
        }
        catch (IOException e) {
            LogUtils.error((String)(FTP_CLIENT_DESTORY_ERROR_MESSAGE + e.getMessage()), (Object[])new Object[]{e});
            return;
        }
        finally {
            try {
                if (this.client.isConnected()) {
                    this.client.disconnect();
                }
            }
            catch (IOException e) {
                LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
            }
            finally {
                this.client = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String remoteDir, String rName, File lFile) {
        String sremoteDir = this.ConvertEncoding(remoteDir);
        String srName = this.ConvertEncoding(rName);
        boolean result = false;
        if (!this.isLogin) {
            this.reInit();
            LogUtils.warn((String)"FTP\u672a\u767b\u5f55\uff0c\u91cd\u65b0\u521d\u59cb\u5316\u3002\u3002\u3002", (Object[])new Object[0]);
        }
        if (this.isLogin) {
            try {
                this.input = new FileInputStream(lFile);
                if (sremoteDir != null && sremoteDir.length() > 0) {
                    boolean bb = this.client.changeWorkingDirectory(sremoteDir);
                    LogUtils.info((String)("\u8fdc\u7a0b\u5730\u5740:" + sremoteDir + ",\u5207\u6362\u7ed3\u679c:" + bb), (Object[])new Object[0]);
                }
                this.client.enterLocalPassiveMode();
                result = this.client.storeFile(srName, this.input);
                LogUtils.info((String)("\u6587\u4ef6[" + lFile.getPath() + "]\u4e0a\u4f20\u7ed3\u679c\uff1a" + result), (Object[])new Object[0]);
            }
            catch (Exception e) {
                result = false;
                LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
            }
            finally {
                try {
                    this.input.close();
                    this.input = null;
                }
                catch (IOException e) {
                    LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadBigFiles(String remoteDir, String rName, File lFile) {
        String sremoteDir = this.ConvertEncoding(remoteDir);
        String srName = this.ConvertEncoding(rName);
        boolean result = false;
        if (!this.isLogin) {
            this.reInit();
            LogUtils.info((String)"FTP\u672a\u767b\u5f55\uff0c\u91cd\u65b0\u521d\u59cb\u5316\u3002\u3002\u3002", (Object[])new Object[0]);
        }
        if (this.isLogin) {
            RandomAccessFile inputRAF = null;
            OutputStream out = null;
            try {
                int c;
                if (sremoteDir != null && sremoteDir.length() > 0) {
                    this.client.changeWorkingDirectory(sremoteDir);
                }
                this.client.enterLocalPassiveMode();
                inputRAF = new RandomAccessFile(lFile, "r");
                out = this.client.storeFileStream(srName);
                byte[] bytes = new byte[1024];
                while ((c = inputRAF.read(bytes)) != -1) {
                    out.write(bytes, 0, c);
                    out.flush();
                }
                out.flush();
            }
            catch (Exception e) {
                LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
            }
            finally {
                try {
                    inputRAF.close();
                }
                catch (IOException ex) {
                    LogUtils.info((String)("" + ex), (Object[])new Object[0]);
                }
                try {
                    out.close();
                    result = this.client.completePendingCommand();
                    LogUtils.info((String)("\u6587\u4ef6[" + lFile.getPath() + "]\u4e0a\u4f20\u7ed3\u679c\uff1a" + result), (Object[])new Object[0]);
                }
                catch (IOException ex) {
                    LogUtils.error((String)ex.getMessage(), (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    public boolean upload(String remoteFile, String localFile) {
        String sremoteFile = this.ConvertEncoding(remoteFile);
        String slocalFile = this.ConvertEncoding(localFile);
        try {
            FileInputStream in = new FileInputStream(slocalFile);
            boolean result = this.upload(sremoteFile, in);
            ((InputStream)in).close();
            return result;
        }
        catch (FileNotFoundException e) {
            LogUtils.error((String)"\u672c\u5730\u6587\u4ef6\u672a\u627e\u5230\uff0c\u4e0a\u4f20\u5931\u8d25", (Object[])new Object[]{e});
        }
        catch (IOException e) {
            LogUtils.error((String)"\u5173\u95ed\u672c\u5730\u6587\u4ef6\u6d41\u51fa\u9519", (Object[])new Object[]{e});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String remoteFile, InputStream in) {
        Object sremoteFile = this.ConvertEncoding(remoteFile);
        LogUtils.info((String)("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
        sremoteFile = ((String)sremoteFile).replaceAll("\\\\", "/");
        if (((String)sremoteFile).startsWith("/") && this.ftpHome != null) {
            sremoteFile = this.ftpHome + (String)sremoteFile;
        }
        OutputStream out = null;
        try {
            this.client.enterLocalPassiveMode();
            String[] pathInfo = ((String)sremoteFile).split("/");
            if (pathInfo.length > 0) {
                int read;
                for (int i = 0; i < pathInfo.length - 1; ++i) {
                    String path = pathInfo[i];
                    if (path.trim().equals("")) continue;
                    this.client.makeDirectory(path);
                    boolean changeRes = this.client.changeWorkingDirectory(path);
                    if (changeRes) continue;
                    LogUtils.info((String)("\u4e0d\u80fd\u6253\u5f00\u76ee\u5f55\uff1a" + this.client.printWorkingDirectory() + "/" + path), (Object[])new Object[0]);
                    LogUtils.error((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                this.client.enterLocalPassiveMode();
                out = this.client.storeFileStream(pathInfo[pathInfo.length - 1]);
                byte[] cache = new byte[4096];
                while ((read = in.read(cache)) != -1) {
                    out.write(cache, 0, read);
                }
                out.flush();
                out.close();
                boolean res = this.client.completePendingCommand();
                if (res) {
                    LogUtils.info((String)("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
                } else {
                    LogUtils.info((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
                }
                boolean bl = res;
                return bl;
            }
        }
        catch (IOException e) {
            LogUtils.error((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
            LogUtils.error((String)"\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Object[])new Object[]{e});
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public InputStream getInputStream(String remoteFile) {
        Object sremoteFile = this.ConvertEncoding(remoteFile);
        this.client.enterLocalPassiveMode();
        InputStream in = null;
        sremoteFile = ((String)sremoteFile).replaceAll("\\\\", "/");
        if (((String)sremoteFile).startsWith("/") && this.ftpHome != null) {
            sremoteFile = this.ftpHome + (String)sremoteFile;
        }
        try {
            in = this.client.retrieveFileStream((String)sremoteFile);
        }
        catch (IOException e) {
            LogUtils.error((String)"ftp\u4e0b\u8f7d\u5931\u8d25\uff01", (Object[])new Object[]{e});
            return null;
        }
        return in;
    }

    public InputStream getBinaryInputStream(String remoteFile) {
        Object sremoteFile = this.ConvertEncoding(remoteFile);
        this.client.enterLocalPassiveMode();
        InputStream in = null;
        sremoteFile = ((String)sremoteFile).replaceAll("\\\\", "/");
        if (((String)sremoteFile).startsWith("/") && this.ftpHome != null) {
            sremoteFile = this.ftpHome + (String)sremoteFile;
        }
        try {
            this.client.setFileType(2);
            in = this.client.retrieveFileStream((String)sremoteFile);
        }
        catch (IOException e) {
            LogUtils.error((String)"getBinaryInputStream:ftp\u4e0b\u8f7d\u5931\u8d25\uff01", (Object[])new Object[]{e});
            return null;
        }
        return in;
    }

    public boolean download(String remoteFile, OutputStream out) {
        Object sremoteFile = this.ConvertEncoding(remoteFile);
        this.client.enterLocalPassiveMode();
        sremoteFile = ((String)sremoteFile).replaceAll("\\\\", "/");
        if (((String)sremoteFile).startsWith("/") && this.ftpHome != null) {
            sremoteFile = this.ftpHome + (String)sremoteFile;
        }
        LogUtils.info((String)("ftp\u4e0b\u8f7d\u6587\u4ef6\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
        try {
            return this.client.retrieveFile((String)sremoteFile, out);
        }
        catch (IOException e) {
            LogUtils.error((String)"ftp\u4e0b\u8f7d\u5931\u8d25\uff01", (Object[])new Object[]{e});
            return false;
        }
    }

    public boolean downloadForKDH(String remoteFile, OutputStream out) {
        String sremoteFile = this.ConvertEncoding(remoteFile);
        this.client.enterLocalPassiveMode();
        sremoteFile = sremoteFile.replaceAll("\\\\", "/");
        LogUtils.info((String)("ftp\u4e0b\u8f7d\u6587\u4ef6\uff1a" + sremoteFile), (Object[])new Object[0]);
        try {
            return this.client.retrieveFile(sremoteFile, out);
        }
        catch (IOException e) {
            LogUtils.error((String)"ftp\u4e0b\u8f7d\u5931\u8d25\uff01", (Object[])new Object[]{e});
            return false;
        }
    }

    public boolean binaryDownload(String remoteFile, OutputStream out) {
        Object sremoteFile = this.ConvertEncoding(remoteFile);
        this.client.enterLocalPassiveMode();
        sremoteFile = ((String)sremoteFile).replaceAll("\\\\", "/");
        if (((String)sremoteFile).startsWith("/") && this.ftpHome != null) {
            sremoteFile = this.ftpHome + (String)sremoteFile;
        }
        LogUtils.info((String)("ftp\u4e0b\u8f7d\u6587\u4ef6\uff1a" + (String)sremoteFile), (Object[])new Object[0]);
        try {
            this.client.setFileType(2);
            return this.client.retrieveFile((String)sremoteFile, out);
        }
        catch (IOException e) {
            LogUtils.error((String)"ftp\u4e0b\u8f7d\u5931\u8d25\uff01", (Object[])new Object[]{e});
            return false;
        }
    }

    public boolean renameFile(String srcFileName, String targFileName) {
        String ssrcFileName = this.ConvertEncoding(srcFileName);
        String stargFileName = this.ConvertEncoding(targFileName);
        LogUtils.info((String)("\u5c06\u4fee\u6539\u6587\u4ef6\u540d" + ssrcFileName + "\u4e3a" + stargFileName), (Object[])new Object[0]);
        boolean bRet = false;
        try {
            bRet = this.client.rename(ssrcFileName, stargFileName);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u91cd\u547d\u540d\u6587\u4ef6\u540d\u5f02\u5e38", (Object[])new Object[]{e});
        }
        return bRet;
    }

    public FTPFile[] listFiles(String path) {
        String spath = this.ConvertEncoding(path);
        FTPFile[] files = null;
        try {
            files = this.client.listFiles(spath);
        }
        catch (IOException e) {
            LogUtils.error((String)"\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5f02\u5e38\uff01", (Object[])new Object[]{e});
        }
        return files;
    }

    public boolean remove(String filePath) {
        try {
            return this.client.remoteStore(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void reInit() {
        this.destroy();
        this.init();
    }

    private String ConvertEncoding(String str) {
        if (str == null || "".equals(str.trim()) || this.controlEncoding == null || "".equals(this.controlEncoding.trim())) {
            return str;
        }
        try {
            return new String(str.getBytes("UTF-8"), this.controlEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.error((String)"\u7f16\u7801\u8f6c\u6362\u9519\u8bef", (Object[])new Object[]{e});
            return str;
        }
    }
}

