/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.common.util;

import cn.hutool.core.util.ObjectUtil;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.date.DateUtils;
import java.io.File;
import java.time.LocalDateTime;
import org.springframework.web.multipart.MultipartFile;

public class OssPathUtil {
    public static String valid(String basePath) {
        if (ObjectUtil.isEmpty((Object)basePath)) {
            basePath = "/";
        }
        if (!((String)(basePath = ((String)basePath).replaceAll("\\\\", "/").replaceAll("//", "/"))).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        return basePath;
    }

    public static String convertPath(String key, Boolean isAbsolute) {
        key = ((String)key).replaceAll("\\\\", "/").replaceAll("//", "/");
        if (isAbsolute.booleanValue() && !((String)key).startsWith("/")) {
            key = "/" + (String)key;
        } else if (!isAbsolute.booleanValue() && ((String)key).startsWith("/")) {
            key = ((String)key).replaceFirst("/", "");
        }
        return key;
    }

    public static String replaceKey(String path, String basePath, Boolean isAbsolute) {
        String newPath = "/".equals(basePath) ? OssPathUtil.convertPath(path, isAbsolute) : OssPathUtil.convertPath(path, isAbsolute).replaceAll(OssPathUtil.convertPath(basePath, isAbsolute), "");
        return OssPathUtil.convertPath(newPath, isAbsolute);
    }

    public static String getTargetName(File file) {
        String date = DateUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy/MM/dd");
        return date + "/" + IdGeneratorUtils.getId() + "/" + file.getName();
    }

    public static String getTargetName(MultipartFile file) {
        String date = DateUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy/MM/dd");
        return date + "/" + IdGeneratorUtils.getId() + "/" + file.getName();
    }
}

