/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.minio.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.oss.common.condition.ConditionalOnOssEnabled;
import com.taotao.cloud.oss.common.service.UploadFileService;
import com.taotao.cloud.oss.minio.properties.MinioProperties;
import com.taotao.cloud.oss.minio.service.MinioUploadFileServiceImpl;
import io.minio.MinioClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnOssEnabled
@EnableConfigurationProperties(value={MinioProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.oss", name={"type"}, havingValue="MINIO")
public class MinioConfiguration
implements InitializingBean {
    private final MinioProperties properties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MinioConfiguration.class, (String)"taotao-cloud-starter-oss-minio", (String[])new String[0]);
    }

    public MinioConfiguration(MinioProperties properties) {
        this.properties = properties;
    }

    @Bean
    public MinioClient minioClient() {
        return MinioClient.builder().endpoint(this.properties.getUrl()).credentials(this.properties.getAccessKey(), this.properties.getSecretKey()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public UploadFileService fileUpload(MinioProperties properties, MinioClient minioClient) {
        return new MinioUploadFileServiceImpl(properties, minioClient);
    }
}

