/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.minio.support;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.io.ByteStreams;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.oss.common.exception.OssException;
import com.taotao.cloud.oss.common.model.DirectoryOssInfo;
import com.taotao.cloud.oss.common.model.FileOssInfo;
import com.taotao.cloud.oss.common.model.OssInfo;
import com.taotao.cloud.oss.common.model.download.DownloadCheckPoint;
import com.taotao.cloud.oss.common.model.download.DownloadObjectStat;
import com.taotao.cloud.oss.common.service.StandardOssClient;
import com.taotao.cloud.oss.common.util.OssPathUtil;
import com.taotao.cloud.oss.minio.support.MinioOssConfig;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.messages.Item;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Headers;

public class MinioOssClient
implements StandardOssClient {
    public static final String MINIO_OBJECT_NAME = "minioClient";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    private MinioClient minioClient;
    private MinioOssConfig minioOssConfig;

    public MinioOssClient(MinioClient minioClient, MinioOssConfig minioOssConfig) {
        this.minioClient = minioClient;
        this.minioOssConfig = minioOssConfig;
    }

    public OssInfo upLoad(InputStream is, String targetName, Boolean isOverride) {
        try {
            String bucket = this.getBucket();
            String key = this.getKey(targetName, false);
            ObjectWriteResponse objectWriteResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(key)).stream(is, (long)is.available(), -1L).build());
            LogUtils.info((String)"minio objectWriteResponse ----- etag: {}, object: {}, versionId:{}, headers: {}", (Object[])new Object[]{objectWriteResponse.etag(), objectWriteResponse.object(), objectWriteResponse.versionId(), objectWriteResponse.headers()});
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
        return this.getInfo(targetName);
    }

    public OssInfo upLoadCheckPoint(File file, String targetName) {
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            this.upLoad(inputStream, targetName, true);
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
        return this.getInfo(targetName);
    }

    public void downLoad(OutputStream os, String targetName) {
        GetObjectResponse is = null;
        try {
            GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucket())).object(this.getKey(targetName, true))).build();
            is = this.minioClient.getObject(getObjectArgs);
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            try {
                throw new OssException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.close(is);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)is);
    }

    public void downLoadCheckPoint(File localFile, String targetName) {
        this.downLoadFile(localFile, targetName, this.minioOssConfig.getSliceConfig(), "minio");
    }

    public DownloadObjectStat getDownloadObjectStat(String targetName) {
        try {
            StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.getBucket())).object(this.getKey(targetName, true))).build();
            StatObjectResponse statObjectResponse = this.minioClient.statObject(statObjectArgs);
            long contentLength = statObjectResponse.size();
            String eTag = statObjectResponse.etag();
            DownloadObjectStat downloadObjectStat = new DownloadObjectStat();
            downloadObjectStat.setSize(contentLength);
            downloadObjectStat.setDigest(eTag);
            downloadObjectStat.setLastModified(Date.from(statObjectResponse.lastModified().toInstant()));
            return downloadObjectStat;
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
    }

    public void prepareDownload(DownloadCheckPoint downloadCheckPoint, File localFile, String targetName, String checkpointFile) {
        long downloadSize;
        downloadCheckPoint.setMagic("92611BED-89E2-46B6-89E5-72F273D4B0A3");
        downloadCheckPoint.setDownloadFile(localFile.getPath());
        downloadCheckPoint.setBucketName(this.getBucket());
        downloadCheckPoint.setKey(this.getKey(targetName, false));
        downloadCheckPoint.setCheckPointFile(checkpointFile);
        downloadCheckPoint.setObjectStat(this.getDownloadObjectStat(targetName));
        if (downloadCheckPoint.getObjectStat().getSize() > 0L) {
            Long partSize = this.minioOssConfig.getSliceConfig().getPartSize();
            long[] slice = this.getDownloadSlice(new long[0], downloadCheckPoint.getObjectStat().getSize());
            downloadCheckPoint.setDownloadParts((List)this.splitDownloadFile(slice[0], slice[1], partSize));
            downloadSize = slice[1];
        } else {
            downloadSize = 0L;
            downloadCheckPoint.setDownloadParts((List)this.splitDownloadOneFile());
        }
        downloadCheckPoint.setOriginPartSize((long)downloadCheckPoint.getDownloadParts().size());
        this.createDownloadTemp(downloadCheckPoint.getTempDownloadFile(), downloadSize);
    }

    public InputStream downloadPart(String key, long start, long end) throws Exception {
        GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucket())).object(key)).offset(Long.valueOf(start))).length(Long.valueOf(end))).build();
        return this.minioClient.getObject(getObjectArgs);
    }

    public void delete(String targetName) {
        try {
            RemoveObjectArgs removeObjectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.getBucket())).object(this.getKey(targetName, true))).build();
            this.minioClient.removeObject(removeObjectArgs);
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
    }

    public void copy(String sourceName, String targetName, Boolean isOverride) {
        try {
            CopyObjectArgs copyObjectArgs = (CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(this.getBucket())).object(this.getKey(targetName, true))).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.getBucket())).object(this.getKey(sourceName, true))).build()).build();
            this.minioClient.copyObject(copyObjectArgs);
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
    }

    public OssInfo getInfo(String targetName, Boolean isRecursion) {
        try {
            String key = this.getKey(targetName, false);
            OssInfo ossInfo = this.getBaseInfo(targetName);
            if (isRecursion.booleanValue() && this.isDirectory(key).booleanValue()) {
                String prefix = OssPathUtil.convertPath((String)key, (Boolean)true);
                ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.getBucket())).delimiter("/").prefix((String)(prefix.endsWith("/") ? prefix : prefix + "/")).build();
                Iterable results = this.minioClient.listObjects(listObjectsArgs);
                ArrayList<OssInfo> fileOssInfos = new ArrayList<OssInfo>();
                ArrayList<OssInfo> directoryInfos = new ArrayList<OssInfo>();
                for (Result result : results) {
                    Item item = (Item)result.get();
                    String childKey = OssPathUtil.replaceKey((String)item.objectName(), (String)this.getBasePath(), (Boolean)true);
                    if (item.isDir()) {
                        directoryInfos.add(this.getInfo(childKey, true));
                        continue;
                    }
                    fileOssInfos.add(this.getInfo(childKey, false));
                }
                if (ObjectUtil.isNotEmpty(fileOssInfos) && fileOssInfos.get(0) instanceof FileOssInfo) {
                    ReflectUtil.setFieldValue((Object)ossInfo, (String)"fileInfos", fileOssInfos);
                }
                if (ObjectUtil.isNotEmpty(directoryInfos) && directoryInfos.get(0) instanceof DirectoryOssInfo) {
                    ReflectUtil.setFieldValue((Object)ossInfo, (String)"directoryInfos", directoryInfos);
                }
            }
            return ossInfo;
        }
        catch (Exception e) {
            throw new OssException((Throwable)e);
        }
    }

    public String getBasePath() {
        return this.minioOssConfig.getBasePath();
    }

    public Map<String, Object> getClientObject() {
        return new HashMap<String, Object>(){
            {
                this.put(MinioOssClient.MINIO_OBJECT_NAME, MinioOssClient.this.getMinioClient());
            }
        };
    }

    private String getBucket() {
        return this.minioOssConfig.getBucketName();
    }

    public OssInfo getBaseInfo(String targetName) {
        FileOssInfo ossInfo;
        String key = this.getKey(targetName, false);
        String bucketName = this.getBucket();
        if (this.isFile(key).booleanValue()) {
            ossInfo = new FileOssInfo();
            try {
                GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(key)).build();
                GetObjectResponse objectResponse = this.minioClient.getObject(getObjectArgs);
                Headers headers = objectResponse.headers();
                ossInfo.setCreateTime(DateUtil.date((Date)headers.getDate("Date")).toString("yyyy-MM-dd HH:mm:ss"));
                ossInfo.setLastUpdateTime(DateUtil.date((Date)headers.getDate("Last-Modified")).toString("yyyy-MM-dd HH:mm:ss"));
                ossInfo.setLength(Long.valueOf(Objects.requireNonNull(headers.get("Content-Length"))));
                ossInfo.setUrl(this.minioOssConfig.getEndpoint() + "/" + bucketName + key);
            }
            catch (Exception e) {
                LogUtils.error((String)"\u83b7\u53d6{}\u6587\u4ef6\u5c5e\u6027\u5931\u8d25", (Object[])new Object[]{key, e});
            }
        } else {
            ossInfo = new DirectoryOssInfo();
        }
        ossInfo.setName(StrUtil.equals((CharSequence)targetName, (CharSequence)"/") ? targetName : FileNameUtil.getName((String)targetName));
        ossInfo.setPath(OssPathUtil.replaceKey((String)targetName, (String)this.minioOssConfig.getBasePath(), (Boolean)true));
        return ossInfo;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    public MinioOssConfig getMinioOssConfig() {
        return this.minioOssConfig;
    }

    public void setMinioOssConfig(MinioOssConfig minioOssConfig) {
        this.minioOssConfig = minioOssConfig;
    }
}

