/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.oss.minio.support;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.taotao.cloud.oss.common.condition.ConditionalOnOssEnabled;
import com.taotao.cloud.oss.common.service.StandardOssClient;
import com.taotao.cloud.oss.minio.support.MinioOssClient;
import com.taotao.cloud.oss.minio.support.MinioOssClientConfig;
import com.taotao.cloud.oss.minio.support.MinioOssConfig;
import com.taotao.cloud.oss.minio.support.MinioOssProperties;
import io.minio.MinioClient;
import io.minio.http.HttpUtils;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnOssEnabled
@EnableConfigurationProperties(value={MinioOssProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.oss", name={"type"}, havingValue="minio")
public class MinioOssConfiguration
implements InitializingBean {
    public static final String DEFAULT_BEAN_NAME = "minioOssClient";
    private final MinioOssProperties minioOssProperties;

    public MinioOssConfiguration(MinioOssProperties minioOssProperties) {
        this.minioOssProperties = minioOssProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public StandardOssClient minioOssClient(MinioOssConfig minioOssConfig) {
        return new MinioOssClient(this.minioClient(minioOssConfig), minioOssConfig);
    }

    public MinioClient minioClient(MinioOssConfig minioOssConfig) {
        MinioOssClientConfig clientConfig = minioOssConfig.getClientConfig();
        OkHttpClient okHttpClient = HttpUtils.newDefaultHttpClient((long)clientConfig.getConnectTimeout(), (long)clientConfig.getWriteTimeout(), (long)clientConfig.getReadTimeout());
        return MinioClient.builder().endpoint(minioOssConfig.getEndpoint()).credentials(minioOssConfig.getAccessKey(), minioOssConfig.getSecretKey()).httpClient(okHttpClient).build();
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, MinioOssConfig> minioOssConfigMap = this.minioOssProperties.getOssConfig();
        if (minioOssConfigMap.isEmpty()) {
            SpringUtil.registerBean((String)DEFAULT_BEAN_NAME, (Object)this.minioOssClient(this.minioOssProperties));
        } else {
            String endpoint = this.minioOssProperties.getEndpoint();
            String accessKey = this.minioOssProperties.getAccessKey();
            String secretKey = this.minioOssProperties.getSecretKey();
            MinioOssClientConfig clientConfig = this.minioOssProperties.getClientConfig();
            minioOssConfigMap.forEach((name, minioOssConfig) -> {
                if (ObjectUtil.isEmpty((Object)minioOssConfig.getEndpoint())) {
                    minioOssConfig.setEndpoint(endpoint);
                }
                if (ObjectUtil.isEmpty((Object)minioOssConfig.getAccessKey())) {
                    minioOssConfig.setAccessKey(accessKey);
                }
                if (ObjectUtil.isEmpty((Object)minioOssConfig.getSecretKey())) {
                    minioOssConfig.setSecretKey(secretKey);
                }
                if (ObjectUtil.isEmpty((Object)minioOssConfig.getClientConfig())) {
                    minioOssConfig.setClientConfig(clientConfig);
                }
                SpringUtil.registerBean((String)name, (Object)this.minioOssClient((MinioOssConfig)minioOssConfig));
            });
        }
    }
}

