/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.api.impl;

import com.google.common.collect.Lists;
import com.taotao.cloud.common.support.handler.IHandler;
import com.taotao.cloud.common.utils.collection.CollectionUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.pinyin.api.IPinyin;
import com.taotao.cloud.pinyin.api.IPinyinContext;
import com.taotao.cloud.pinyin.spi.IPinyinChinese;
import com.taotao.cloud.pinyin.spi.IPinyinData;
import com.taotao.cloud.pinyin.spi.IPinyinSegment;
import com.taotao.cloud.pinyin.spi.IPinyinTone;
import com.taotao.cloud.pinyin.spi.IPinyinToneReverse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Pinyin
implements IPinyin {
    @Override
    public String toPinyin(String string, IPinyinContext context) {
        List<String> stringList = this.toPinyinList(string, context);
        String connector = context.connector();
        return StringUtils.join(stringList, (String)connector);
    }

    @Override
    public List<String> toPinyinList(char chinese, IPinyinContext context) {
        String original = String.valueOf(chinese);
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(original)) {
            String simple = pinyinChinese.toSimple(original);
            return pinyinTone.toneList(simple, context);
        }
        return Collections.singletonList(original);
    }

    @Override
    public boolean hasSamePinyin(char chineseOne, char chineseTwo, IPinyinContext context) {
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(chineseOne) && pinyinChinese.isChinese(chineseTwo)) {
            if (chineseOne == chineseTwo) {
                return true;
            }
            String simpleOne = pinyinChinese.toSimple(chineseOne);
            String simpleTwo = pinyinChinese.toSimple(chineseTwo);
            List<String> tonesOne = pinyinTone.toneList(simpleOne, context);
            List<String> tonesTwo = pinyinTone.toneList(simpleTwo, context);
            return CollectionUtils.containAny(tonesOne, tonesTwo);
        }
        return false;
    }

    @Override
    @Deprecated
    public List<Integer> toneNumList(String chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    @Deprecated
    public List<Integer> toneNumList(char chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    @Deprecated
    public List<String> shengMuList(String chinese, IPinyinContext context) {
        IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, (IHandler<String, String>)((IHandler)pinyinData::shengMu));
    }

    @Override
    @Deprecated
    public List<String> yunMuList(String chinese, IPinyinContext context) {
        IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, (IHandler<String, String>)((IHandler)pinyinData::yunMu));
    }

    @Override
    public List<String> samePinyinList(String pinyin, boolean sameToneNum, IPinyinContext context) {
        IPinyinToneReverse pinyinToneReverse = context.pinyinToneReverse();
        if (sameToneNum) {
            return pinyinToneReverse.getHanziList(pinyin);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String pinyinRaw = pinyin.substring(0, pinyin.length() - 1);
        for (int i = 1; i <= 5; ++i) {
            String pinyinLast = pinyinRaw + i;
            List<String> characterList = pinyinToneReverse.getHanziList(pinyinLast);
            if (!CollectionUtils.isNotEmpty(characterList)) continue;
            resultList.addAll(characterList);
        }
        return resultList;
    }

    private List<String> toPinyinList(String string, IPinyinContext context) {
        if (StringUtils.isEmptyTrim((String)string)) {
            return Collections.emptyList();
        }
        IPinyinSegment pinyinSegment = context.segment();
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        List<String> entryList = pinyinSegment.segment(string);
        ArrayList resultList = Lists.newArrayList();
        for (String entry : entryList) {
            if (StringUtils.isEmptyTrim((String)entry)) continue;
            if (pinyinChinese.isChinese(entry)) {
                String simple = pinyinChinese.toSimple(entry);
                String tone = pinyinTone.tone(simple, context);
                resultList.add(tone);
                continue;
            }
            resultList.add(entry);
        }
        return resultList;
    }

    private List<Integer> buildToneNumList(List<String> pinyinList, IPinyinTone pinyinTone) {
        ArrayList resultList = Lists.newArrayList();
        for (String pinyin : pinyinList) {
            Integer toneNum = pinyinTone.toneNum(pinyin);
            resultList.add(toneNum);
        }
        return resultList;
    }

    private List<String> normalPinyinHandler(String chinese, IPinyinContext context, IHandler<String, String> handler) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        ArrayList resultList = Lists.newArrayList();
        for (String pinyin : pinyinList) {
            String result = (String)handler.handle((Object)pinyin);
            resultList.add(result);
        }
        return resultList;
    }
}

