/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.bs;

import com.taotao.cloud.common.support.instance.impl.Instances;
import com.taotao.cloud.common.utils.common.ArgUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.pinyin.api.IPinyin;
import com.taotao.cloud.pinyin.api.IPinyinContext;
import com.taotao.cloud.pinyin.api.impl.Pinyin;
import com.taotao.cloud.pinyin.api.impl.PinyinContext;
import com.taotao.cloud.pinyin.spi.IPinyinChinese;
import com.taotao.cloud.pinyin.spi.IPinyinData;
import com.taotao.cloud.pinyin.spi.IPinyinSegment;
import com.taotao.cloud.pinyin.spi.IPinyinTone;
import com.taotao.cloud.pinyin.spi.IPinyinToneReverse;
import com.taotao.cloud.pinyin.spi.IPinyinToneStyle;
import com.taotao.cloud.pinyin.support.chinese.PinyinChineses;
import com.taotao.cloud.pinyin.support.data.PinyinData;
import com.taotao.cloud.pinyin.support.segment.PinyinSegments;
import com.taotao.cloud.pinyin.support.style.PinyinToneStyles;
import com.taotao.cloud.pinyin.support.tone.PinyinToneReverse;
import com.taotao.cloud.pinyin.support.tone.PinyinTones;
import java.util.List;

public final class PinyinBs {
    private IPinyinSegment pinyinSegment = PinyinSegments.defaults();
    private final IPinyinChinese pinyinChinese = PinyinChineses.defaults();
    private final IPinyinTone pinyinTone = PinyinTones.defaults();
    private final IPinyinData data = (IPinyinData)Instances.singleton(PinyinData.class);
    private IPinyinToneStyle style = PinyinToneStyles.defaults();
    private final IPinyin pinyin = (IPinyin)Instances.singleton(Pinyin.class);
    private String connector = " ";
    private IPinyinToneReverse pinyinToneReverse = new PinyinToneReverse();
    private IPinyinContext pinyinContext;

    private PinyinBs() {
    }

    public static PinyinBs newInstance() {
        return new PinyinBs();
    }

    public PinyinBs style(IPinyinToneStyle style) {
        ArgUtils.notNull((Object)style, (String)"style");
        this.style = style;
        return this;
    }

    public PinyinBs connector(String connector) {
        this.connector = connector;
        return this;
    }

    public PinyinBs segment(IPinyinSegment pinyinSegment) {
        ArgUtils.notNull((Object)pinyinSegment, (String)"segment");
        this.pinyinSegment = pinyinSegment;
        return this;
    }

    public PinyinBs pinyinToneReverse(IPinyinToneReverse pinyinToneReverse) {
        ArgUtils.notNull((Object)pinyinToneReverse, (String)"pinyinToneReverse");
        this.pinyinToneReverse = pinyinToneReverse;
        return this;
    }

    public PinyinBs init() {
        this.pinyinContext = PinyinContext.newInstance().chinese(this.pinyinChinese).data(this.data).segment(this.pinyinSegment).style(this.style).tone(this.pinyinTone).connector(this.connector).pinyinToneReverse(this.pinyinToneReverse);
        return this;
    }

    private synchronized void statusCheck() {
        if (this.pinyinContext == null) {
            this.init();
        }
    }

    public String toPinyin(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        this.statusCheck();
        return this.pinyin.toPinyin(string, this.pinyinContext);
    }

    public List<String> toPinyinList(char chinese) {
        this.statusCheck();
        return this.pinyin.toPinyinList(chinese, this.pinyinContext);
    }

    public boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        this.statusCheck();
        return this.pinyin.hasSamePinyin(chineseOne, chineseTwo, this.pinyinContext);
    }

    public List<String> samePinyinList(String pinyin, boolean sameTone) {
        this.statusCheck();
        return this.pinyin.samePinyinList(pinyin, sameTone, this.pinyinContext);
    }
}

