/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.constant.enums;

public enum PinyinToneNumEnum {
    ONE(1, "\u9634\u5e73"),
    TWO(2, "\u9633\u5e73"),
    THREE(3, "\u4e0a\u58f0"),
    FOUR(4, "\u53bb\u58f0"),
    FIVE(5, "\u8f7b\u58f0"),
    UN_KNOWN(-1, "\u672a\u77e5");

    private final int num;
    private final String desc;

    private PinyinToneNumEnum(int num, String desc) {
        this.num = num;
        this.desc = desc;
    }

    public int num() {
        return this.num;
    }

    public String desc() {
        return this.desc;
    }

    public String toString() {
        return "PinyinToneNumEnum{num=" + this.num + ", desc='" + this.desc + "'}";
    }

    public static boolean isPing(int toneNum) {
        return PinyinToneNumEnum.ONE.num == toneNum || PinyinToneNumEnum.TWO.num == toneNum;
    }

    public static boolean isZe(int toneNum) {
        return PinyinToneNumEnum.THREE.num == toneNum || PinyinToneNumEnum.FOUR.num == toneNum;
    }

    public static boolean isSoftly(int toneNum) {
        return PinyinToneNumEnum.FIVE.num == toneNum;
    }
}

