/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.roses;

import com.taotao.cloud.pinyin.roses.api.PinYinApi;
import com.taotao.cloud.pinyin.roses.api.exception.PinyinException;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinServiceImpl
implements PinYinApi {
    private final Properties properties = new Properties();

    public PinyinServiceImpl() {
        this.init();
    }

    public void init() {
        this.properties.put("\u533a", "O");
        this.properties.put("\u665f", "C");
        this.properties.put("\u4e50", "Y");
        this.properties.put("\u5458", "Y");
        this.properties.put("\u8d20", "Y");
        this.properties.put("\u9ed1", "H");
        this.properties.put("\u91cd", "C");
        this.properties.put("\u4ec7", "Q");
        this.properties.put("\u79d8", "B");
        this.properties.put("\u51bc", "X");
        this.properties.put("\u89e3", "X");
        this.properties.put("\u6298", "S");
        this.properties.put("\u5355", "S");
        this.properties.put("\u6734", "P");
        this.properties.put("\u7fdf", "Z");
        this.properties.put("\u67e5", "Z");
        this.properties.put("\u76d6", "G");
        this.properties.put("\u4e07\u4fdf", "M I");
        this.properties.put("\u5c09\u8fdf", "Y C");
    }

    @Override
    public String getLastnameFirstLetterUpper(String lastnameChines) {
        Set<Object> keys = this.properties.keySet();
        for (Object lastNameObject : keys) {
            String lastname = (String)lastNameObject;
            if (lastnameChines.length() < lastname.length() || !lastnameChines.startsWith(lastname)) continue;
            return this.properties.getProperty(lastname);
        }
        return PinyinServiceImpl.getFirstLetters(lastnameChines, HanyuPinyinCaseType.UPPERCASE);
    }

    @Override
    public String getChineseStringFirstLetterUpper(String chineseString) {
        return PinyinServiceImpl.getFirstLetters(chineseString, HanyuPinyinCaseType.UPPERCASE);
    }

    @Override
    public String parsePinyinString(String chineseString) {
        char[] chineseWordsArray = chineseString.toCharArray();
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder finalPinyinString = new StringBuilder();
        try {
            for (char chineseWord : chineseWordsArray) {
                if (Character.toString(chineseWord).matches("[\u4e00-\u9fa5]+")) {
                    String[] strings = PinyinHelper.toHanyuPinyinStringArray((char)chineseWord, (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat);
                    finalPinyinString.append(strings[0]);
                    continue;
                }
                finalPinyinString.append(chineseWord);
            }
            return finalPinyinString.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination e1) {
            throw new PinyinException(50012, e1.getMessage());
        }
    }

    @Override
    public String parseEveryPinyinFirstLetter(String chinesString) {
        StringBuilder convert = new StringBuilder();
        for (int i = 0; i < chinesString.length(); ++i) {
            char word = chinesString.charAt(i);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                convert.append(pinyinArray[0].charAt(0));
                continue;
            }
            convert.append(word);
        }
        return convert.toString();
    }

    @Override
    public String getChineseAscii(String chineseString) {
        byte[] bGBK;
        StringBuilder strBuf = new StringBuilder();
        for (byte b : bGBK = chineseString.getBytes()) {
            strBuf.append(Integer.toHexString(b & 0xFF));
        }
        return strBuf.toString();
    }

    private static String getFirstLetters(String chineseString, HanyuPinyinCaseType caseType) {
        char[] chinesWords = chineseString.trim().toCharArray();
        StringBuilder hanyupinyin = new StringBuilder();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            for (char word : chinesWords) {
                String str = String.valueOf(word);
                if (str.matches("[\u4e00-\u9fa5]+")) {
                    hanyupinyin.append(PinyinHelper.toHanyuPinyinStringArray((char)word, (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0));
                    continue;
                }
                if (str.matches("[0-9]+")) {
                    hanyupinyin.append(word);
                    continue;
                }
                if (str.matches("[a-zA-Z]+")) {
                    hanyupinyin.append(word);
                    continue;
                }
                hanyupinyin.append(word);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new PinyinException(500012, e.getMessage());
        }
        return hanyupinyin.toString();
    }
}

